/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudcontrolapi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cloudcontrolapi.model.ResourceDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String typeName;
    private List<ResourceDescription> resourceDescriptions;
    private String nextToken;

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ListResourcesResult withTypeName(String typeName) {
        this.setTypeName(typeName);
        return this;
    }

    public List<ResourceDescription> getResourceDescriptions() {
        return this.resourceDescriptions;
    }

    public void setResourceDescriptions(Collection<ResourceDescription> resourceDescriptions) {
        if (resourceDescriptions == null) {
            this.resourceDescriptions = null;
            return;
        }
        this.resourceDescriptions = new ArrayList<ResourceDescription>(resourceDescriptions);
    }

    public ListResourcesResult withResourceDescriptions(ResourceDescription ... resourceDescriptions) {
        if (this.resourceDescriptions == null) {
            this.setResourceDescriptions(new ArrayList<ResourceDescription>(resourceDescriptions.length));
        }
        for (ResourceDescription ele : resourceDescriptions) {
            this.resourceDescriptions.add(ele);
        }
        return this;
    }

    public ListResourcesResult withResourceDescriptions(Collection<ResourceDescription> resourceDescriptions) {
        this.setResourceDescriptions(resourceDescriptions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypeName() != null) {
            sb.append("TypeName: ").append(this.getTypeName()).append(",");
        }
        if (this.getResourceDescriptions() != null) {
            sb.append("ResourceDescriptions: ").append(this.getResourceDescriptions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesResult)) {
            return false;
        }
        ListResourcesResult other = (ListResourcesResult)obj;
        if (other.getTypeName() == null ^ this.getTypeName() == null) {
            return false;
        }
        if (other.getTypeName() != null && !other.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        if (other.getResourceDescriptions() == null ^ this.getResourceDescriptions() == null) {
            return false;
        }
        if (other.getResourceDescriptions() != null && !other.getResourceDescriptions().equals(this.getResourceDescriptions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceDescriptions() == null ? 0 : this.getResourceDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListResourcesResult clone() {
        try {
            return (ListResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

