/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudfront.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyValueStore" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateKeyValueStoreRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the Key Value Store to update.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The comment of the Key Value Store to update.
     * </p>
     */
    private String comment;
    /**
     * <p>
     * The Key Value Store to update, if a match occurs.
     * </p>
     */
    private String ifMatch;

    /**
     * <p>
     * The name of the Key Value Store to update.
     * </p>
     * 
     * @param name
     *        The name of the Key Value Store to update.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the Key Value Store to update.
     * </p>
     * 
     * @return The name of the Key Value Store to update.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the Key Value Store to update.
     * </p>
     * 
     * @param name
     *        The name of the Key Value Store to update.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateKeyValueStoreRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The comment of the Key Value Store to update.
     * </p>
     * 
     * @param comment
     *        The comment of the Key Value Store to update.
     */

    public void setComment(String comment) {
        this.comment = comment;
    }

    /**
     * <p>
     * The comment of the Key Value Store to update.
     * </p>
     * 
     * @return The comment of the Key Value Store to update.
     */

    public String getComment() {
        return this.comment;
    }

    /**
     * <p>
     * The comment of the Key Value Store to update.
     * </p>
     * 
     * @param comment
     *        The comment of the Key Value Store to update.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateKeyValueStoreRequest withComment(String comment) {
        setComment(comment);
        return this;
    }

    /**
     * <p>
     * The Key Value Store to update, if a match occurs.
     * </p>
     * 
     * @param ifMatch
     *        The Key Value Store to update, if a match occurs.
     */

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    /**
     * <p>
     * The Key Value Store to update, if a match occurs.
     * </p>
     * 
     * @return The Key Value Store to update, if a match occurs.
     */

    public String getIfMatch() {
        return this.ifMatch;
    }

    /**
     * <p>
     * The Key Value Store to update, if a match occurs.
     * </p>
     * 
     * @param ifMatch
     *        The Key Value Store to update, if a match occurs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateKeyValueStoreRequest withIfMatch(String ifMatch) {
        setIfMatch(ifMatch);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getComment() != null)
            sb.append("Comment: ").append(getComment()).append(",");
        if (getIfMatch() != null)
            sb.append("IfMatch: ").append(getIfMatch());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateKeyValueStoreRequest == false)
            return false;
        UpdateKeyValueStoreRequest other = (UpdateKeyValueStoreRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getComment() == null ^ this.getComment() == null)
            return false;
        if (other.getComment() != null && other.getComment().equals(this.getComment()) == false)
            return false;
        if (other.getIfMatch() == null ^ this.getIfMatch() == null)
            return false;
        if (other.getIfMatch() != null && other.getIfMatch().equals(this.getIfMatch()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getComment() == null) ? 0 : getComment().hashCode());
        hashCode = prime * hashCode + ((getIfMatch() == null) ? 0 : getIfMatch().hashCode());
        return hashCode;
    }

    @Override
    public UpdateKeyValueStoreRequest clone() {
        return (UpdateKeyValueStoreRequest) super.clone();
    }

}
