/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.EnvironmentImage;
import com.amazonaws.services.codebuild.model.EnvironmentLanguage;
import com.amazonaws.services.codebuild.model.transform.EnvironmentImageJsonMarshaller;
import java.util.List;

public class EnvironmentLanguageJsonMarshaller {
    private static EnvironmentLanguageJsonMarshaller instance;

    public void marshall(EnvironmentLanguage environmentLanguage, StructuredJsonGenerator jsonGenerator) {
        if (environmentLanguage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<EnvironmentImage> imagesList;
            jsonGenerator.writeStartObject();
            if (environmentLanguage.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(environmentLanguage.getLanguage());
            }
            if ((imagesList = environmentLanguage.getImages()) != null) {
                jsonGenerator.writeFieldName("images");
                jsonGenerator.writeStartArray();
                for (EnvironmentImage imagesListValue : imagesList) {
                    if (imagesListValue == null) continue;
                    EnvironmentImageJsonMarshaller.getInstance().marshall(imagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnvironmentLanguageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnvironmentLanguageJsonMarshaller();
        }
        return instance;
    }
}

