/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.transform.SourceAuthJsonMarshaller;

public class ProjectSourceJsonMarshaller {
    private static ProjectSourceJsonMarshaller instance;

    public void marshall(ProjectSource projectSource, StructuredJsonGenerator jsonGenerator) {
        if (projectSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (projectSource.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(projectSource.getType());
            }
            if (projectSource.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(projectSource.getLocation());
            }
            if (projectSource.getBuildspec() != null) {
                jsonGenerator.writeFieldName("buildspec").writeValue(projectSource.getBuildspec());
            }
            if (projectSource.getAuth() != null) {
                jsonGenerator.writeFieldName("auth");
                SourceAuthJsonMarshaller.getInstance().marshall(projectSource.getAuth(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProjectSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProjectSourceJsonMarshaller();
        }
        return instance;
    }
}

