/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.util.json.JSONWriter;

public class TriggerConfigJsonMarshaller {
    private static TriggerConfigJsonMarshaller instance;

    public void marshall(TriggerConfig triggerConfig, JSONWriter jsonWriter) {
        if (triggerConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList triggerEventsList;
            jsonWriter.object();
            if (triggerConfig.getTriggerName() != null) {
                jsonWriter.key("triggerName").value((Object)triggerConfig.getTriggerName());
            }
            if (triggerConfig.getTriggerTargetArn() != null) {
                jsonWriter.key("triggerTargetArn").value((Object)triggerConfig.getTriggerTargetArn());
            }
            if (!(triggerEventsList = (SdkInternalList)triggerConfig.getTriggerEvents()).isEmpty() || !triggerEventsList.isAutoConstruct()) {
                jsonWriter.key("triggerEvents");
                jsonWriter.array();
                for (String triggerEventsListValue : triggerEventsList) {
                    if (triggerEventsListValue == null) continue;
                    jsonWriter.value((Object)triggerEventsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TriggerConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TriggerConfigJsonMarshaller();
        }
        return instance;
    }
}

