/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codedeploy.model.CreateDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.transform.MinimumHealthyHostsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateDeploymentConfigRequestMarshaller
implements Marshaller<Request<CreateDeploymentConfigRequest>, CreateDeploymentConfigRequest> {
    public Request<CreateDeploymentConfigRequest> marshall(CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        if (createDeploymentConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentConfigRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeploymentConfig");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentConfigRequest.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(createDeploymentConfigRequest.getDeploymentConfigName());
            }
            if (createDeploymentConfigRequest.getMinimumHealthyHosts() != null) {
                jsonGenerator.writeFieldName("minimumHealthyHosts");
                MinimumHealthyHostsJsonMarshaller.getInstance().marshall(createDeploymentConfigRequest.getMinimumHealthyHosts(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

