/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.AutoScalingGroup;
import com.amazonaws.services.codedeploy.model.DeploymentGroupInfo;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.services.codedeploy.model.transform.AutoScalingGroupJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TriggerConfigJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class DeploymentGroupInfoJsonMarshaller {
    private static DeploymentGroupInfoJsonMarshaller instance;

    public void marshall(DeploymentGroupInfo deploymentGroupInfo, SdkJsonGenerator jsonGenerator) {
        if (deploymentGroupInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList triggerConfigurationsList;
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            jsonGenerator.writeStartObject();
            if (deploymentGroupInfo.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(deploymentGroupInfo.getApplicationName());
            }
            if (deploymentGroupInfo.getDeploymentGroupId() != null) {
                jsonGenerator.writeFieldName("deploymentGroupId").writeValue(deploymentGroupInfo.getDeploymentGroupId());
            }
            if (deploymentGroupInfo.getDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("deploymentGroupName").writeValue(deploymentGroupInfo.getDeploymentGroupName());
            }
            if (deploymentGroupInfo.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(deploymentGroupInfo.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)deploymentGroupInfo.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ec2TagFilters");
                jsonGenerator.writeStartArray();
                for (EC2TagFilter ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall(ec2TagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)deploymentGroupInfo.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("onPremisesInstanceTagFilters");
                jsonGenerator.writeStartArray();
                for (TagFilter onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(onPremisesInstanceTagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)deploymentGroupInfo.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (AutoScalingGroup autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    AutoScalingGroupJsonMarshaller.getInstance().marshall(autoScalingGroupsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (deploymentGroupInfo.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("serviceRoleArn").writeValue(deploymentGroupInfo.getServiceRoleArn());
            }
            if (deploymentGroupInfo.getTargetRevision() != null) {
                jsonGenerator.writeFieldName("targetRevision");
                RevisionLocationJsonMarshaller.getInstance().marshall(deploymentGroupInfo.getTargetRevision(), jsonGenerator);
            }
            if (!(triggerConfigurationsList = (SdkInternalList)deploymentGroupInfo.getTriggerConfigurations()).isEmpty() || !triggerConfigurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("triggerConfigurations");
                jsonGenerator.writeStartArray();
                for (TriggerConfig triggerConfigurationsListValue : triggerConfigurationsList) {
                    if (triggerConfigurationsListValue == null) continue;
                    TriggerConfigJsonMarshaller.getInstance().marshall(triggerConfigurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentGroupInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentGroupInfoJsonMarshaller();
        }
        return instance;
    }
}

