/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.LifecycleEvent;
import com.amazonaws.services.codedeploy.model.transform.DiagnosticsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class LifecycleEventJsonMarshaller {
    private static LifecycleEventJsonMarshaller instance;

    public void marshall(LifecycleEvent lifecycleEvent, SdkJsonGenerator jsonGenerator) {
        if (lifecycleEvent == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (lifecycleEvent.getLifecycleEventName() != null) {
                jsonGenerator.writeFieldName("lifecycleEventName").writeValue(lifecycleEvent.getLifecycleEventName());
            }
            if (lifecycleEvent.getDiagnostics() != null) {
                jsonGenerator.writeFieldName("diagnostics");
                DiagnosticsJsonMarshaller.getInstance().marshall(lifecycleEvent.getDiagnostics(), jsonGenerator);
            }
            if (lifecycleEvent.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(lifecycleEvent.getStartTime());
            }
            if (lifecycleEvent.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(lifecycleEvent.getEndTime());
            }
            if (lifecycleEvent.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(lifecycleEvent.getStatus());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LifecycleEventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LifecycleEventJsonMarshaller();
        }
        return instance;
    }
}

