/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.ListOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListOnPremisesInstancesRequestMarshaller
implements Marshaller<Request<ListOnPremisesInstancesRequest>, ListOnPremisesInstancesRequest> {
    public Request<ListOnPremisesInstancesRequest> marshall(ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {
        if (listOnPremisesInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listOnPremisesInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListOnPremisesInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagFiltersList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listOnPremisesInstancesRequest.getRegistrationStatus() != null) {
                jsonGenerator.writeFieldName("registrationStatus").writeValue(listOnPremisesInstancesRequest.getRegistrationStatus());
            }
            if (!(tagFiltersList = (SdkInternalList)listOnPremisesInstancesRequest.getTagFilters()).isEmpty() || !tagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tagFilters");
                jsonGenerator.writeStartArray();
                for (TagFilter tagFiltersListValue : tagFiltersList) {
                    if (tagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(tagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listOnPremisesInstancesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listOnPremisesInstancesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

