/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.amazonaws.util.json.SdkJsonGenerator;

public class S3LocationJsonMarshaller {
    private static S3LocationJsonMarshaller instance;

    public void marshall(S3Location s3Location, SdkJsonGenerator jsonGenerator) {
        if (s3Location == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3Location.getBucket() != null) {
                jsonGenerator.writeFieldName("bucket").writeValue(s3Location.getBucket());
            }
            if (s3Location.getKey() != null) {
                jsonGenerator.writeFieldName("key").writeValue(s3Location.getKey());
            }
            if (s3Location.getBundleType() != null) {
                jsonGenerator.writeFieldName("bundleType").writeValue(s3Location.getBundleType());
            }
            if (s3Location.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(s3Location.getVersion());
            }
            if (s3Location.getETag() != null) {
                jsonGenerator.writeFieldName("eTag").writeValue(s3Location.getETag());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3LocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3LocationJsonMarshaller();
        }
        return instance;
    }
}

