/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.InstanceSummary;
import com.amazonaws.services.codedeploy.model.LifecycleEvent;
import com.amazonaws.services.codedeploy.model.transform.LifecycleEventJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class InstanceSummaryJsonMarshaller {
    private static InstanceSummaryJsonMarshaller instance;

    public void marshall(InstanceSummary instanceSummary, StructuredJsonGenerator jsonGenerator) {
        if (instanceSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList lifecycleEventsList;
            jsonGenerator.writeStartObject();
            if (instanceSummary.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(instanceSummary.getDeploymentId());
            }
            if (instanceSummary.getInstanceId() != null) {
                jsonGenerator.writeFieldName("instanceId").writeValue(instanceSummary.getInstanceId());
            }
            if (instanceSummary.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(instanceSummary.getStatus());
            }
            if (instanceSummary.getLastUpdatedAt() != null) {
                jsonGenerator.writeFieldName("lastUpdatedAt").writeValue(instanceSummary.getLastUpdatedAt());
            }
            if (!(lifecycleEventsList = (SdkInternalList)instanceSummary.getLifecycleEvents()).isEmpty() || !lifecycleEventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("lifecycleEvents");
                jsonGenerator.writeStartArray();
                for (LifecycleEvent lifecycleEventsListValue : lifecycleEventsList) {
                    if (lifecycleEventsListValue == null) continue;
                    LifecycleEventJsonMarshaller.getInstance().marshall(lifecycleEventsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceSummaryJsonMarshaller();
        }
        return instance;
    }
}

