/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.AlarmConfiguration;
import com.amazonaws.services.codedeploy.model.AutoRollbackConfiguration;
import com.amazonaws.services.codedeploy.model.AutoScalingGroup;
import com.amazonaws.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import com.amazonaws.services.codedeploy.model.DeploymentStyle;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.LoadBalancerInfo;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.services.codedeploy.model.transform.DeploymentGroupInfoMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeploymentGroupInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationName;
    private String deploymentGroupId;
    private String deploymentGroupName;
    private String deploymentConfigName;
    private SdkInternalList<EC2TagFilter> ec2TagFilters;
    private SdkInternalList<TagFilter> onPremisesInstanceTagFilters;
    private SdkInternalList<AutoScalingGroup> autoScalingGroups;
    private String serviceRoleArn;
    private RevisionLocation targetRevision;
    private SdkInternalList<TriggerConfig> triggerConfigurations;
    private AlarmConfiguration alarmConfiguration;
    private AutoRollbackConfiguration autoRollbackConfiguration;
    private DeploymentStyle deploymentStyle;
    private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private LoadBalancerInfo loadBalancerInfo;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public DeploymentGroupInfo withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setDeploymentGroupId(String deploymentGroupId) {
        this.deploymentGroupId = deploymentGroupId;
    }

    public String getDeploymentGroupId() {
        return this.deploymentGroupId;
    }

    public DeploymentGroupInfo withDeploymentGroupId(String deploymentGroupId) {
        this.setDeploymentGroupId(deploymentGroupId);
        return this;
    }

    public void setDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public DeploymentGroupInfo withDeploymentGroupName(String deploymentGroupName) {
        this.setDeploymentGroupName(deploymentGroupName);
        return this;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public DeploymentGroupInfo withDeploymentConfigName(String deploymentConfigName) {
        this.setDeploymentConfigName(deploymentConfigName);
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new SdkInternalList();
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        this.ec2TagFilters = new SdkInternalList(ec2TagFilters);
    }

    public DeploymentGroupInfo withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.ec2TagFilters == null) {
            this.setEc2TagFilters((Collection<EC2TagFilter>)new SdkInternalList(ec2TagFilters.length));
        }
        for (EC2TagFilter ele : ec2TagFilters) {
            this.ec2TagFilters.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        this.setEc2TagFilters(ec2TagFilters);
        return this;
    }

    public List<TagFilter> getOnPremisesInstanceTagFilters() {
        if (this.onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = new SdkInternalList();
        }
        return this.onPremisesInstanceTagFilters;
    }

    public void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        if (onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = null;
            return;
        }
        this.onPremisesInstanceTagFilters = new SdkInternalList(onPremisesInstanceTagFilters);
    }

    public DeploymentGroupInfo withOnPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
        if (this.onPremisesInstanceTagFilters == null) {
            this.setOnPremisesInstanceTagFilters((Collection<TagFilter>)new SdkInternalList(onPremisesInstanceTagFilters.length));
        }
        for (TagFilter ele : onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        this.setOnPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new SdkInternalList();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new SdkInternalList(autoScalingGroups);
    }

    public DeploymentGroupInfo withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups((Collection<AutoScalingGroup>)new SdkInternalList(autoScalingGroups.length));
        }
        for (AutoScalingGroup ele : autoScalingGroups) {
            this.autoScalingGroups.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public DeploymentGroupInfo withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setTargetRevision(RevisionLocation targetRevision) {
        this.targetRevision = targetRevision;
    }

    public RevisionLocation getTargetRevision() {
        return this.targetRevision;
    }

    public DeploymentGroupInfo withTargetRevision(RevisionLocation targetRevision) {
        this.setTargetRevision(targetRevision);
        return this;
    }

    public List<TriggerConfig> getTriggerConfigurations() {
        if (this.triggerConfigurations == null) {
            this.triggerConfigurations = new SdkInternalList();
        }
        return this.triggerConfigurations;
    }

    public void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        if (triggerConfigurations == null) {
            this.triggerConfigurations = null;
            return;
        }
        this.triggerConfigurations = new SdkInternalList(triggerConfigurations);
    }

    public DeploymentGroupInfo withTriggerConfigurations(TriggerConfig ... triggerConfigurations) {
        if (this.triggerConfigurations == null) {
            this.setTriggerConfigurations((Collection<TriggerConfig>)new SdkInternalList(triggerConfigurations.length));
        }
        for (TriggerConfig ele : triggerConfigurations) {
            this.triggerConfigurations.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        this.setTriggerConfigurations(triggerConfigurations);
        return this;
    }

    public void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.alarmConfiguration = alarmConfiguration;
    }

    public AlarmConfiguration getAlarmConfiguration() {
        return this.alarmConfiguration;
    }

    public DeploymentGroupInfo withAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.setAlarmConfiguration(alarmConfiguration);
        return this;
    }

    public void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.autoRollbackConfiguration = autoRollbackConfiguration;
    }

    public AutoRollbackConfiguration getAutoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentGroupInfo withAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.setAutoRollbackConfiguration(autoRollbackConfiguration);
        return this;
    }

    public void setDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.deploymentStyle = deploymentStyle;
    }

    public DeploymentStyle getDeploymentStyle() {
        return this.deploymentStyle;
    }

    public DeploymentGroupInfo withDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.setDeploymentStyle(deploymentStyle);
        return this;
    }

    public void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
    }

    public BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public DeploymentGroupInfo withBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.setBlueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
        return this;
    }

    public void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.loadBalancerInfo = loadBalancerInfo;
    }

    public LoadBalancerInfo getLoadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public DeploymentGroupInfo withLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.setLoadBalancerInfo(loadBalancerInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getDeploymentGroupId() != null) {
            sb.append("DeploymentGroupId: ").append(this.getDeploymentGroupId()).append(",");
        }
        if (this.getDeploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.getDeploymentGroupName()).append(",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.getDeploymentConfigName()).append(",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.getEc2TagFilters()).append(",");
        }
        if (this.getOnPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.getOnPremisesInstanceTagFilters()).append(",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getTargetRevision() != null) {
            sb.append("TargetRevision: ").append(this.getTargetRevision()).append(",");
        }
        if (this.getTriggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.getTriggerConfigurations()).append(",");
        }
        if (this.getAlarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.getAlarmConfiguration()).append(",");
        }
        if (this.getAutoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.getAutoRollbackConfiguration()).append(",");
        }
        if (this.getDeploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.getDeploymentStyle()).append(",");
        }
        if (this.getBlueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.getBlueGreenDeploymentConfiguration()).append(",");
        }
        if (this.getLoadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.getLoadBalancerInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroupId() == null ^ this.getDeploymentGroupId() == null) {
            return false;
        }
        if (other.getDeploymentGroupId() != null && !other.getDeploymentGroupId().equals(this.getDeploymentGroupId())) {
            return false;
        }
        if (other.getDeploymentGroupName() == null ^ this.getDeploymentGroupName() == null) {
            return false;
        }
        if (other.getDeploymentGroupName() != null && !other.getDeploymentGroupName().equals(this.getDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() == null ^ this.getOnPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() != null && !other.getOnPremisesInstanceTagFilters().equals(this.getOnPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getTargetRevision() == null ^ this.getTargetRevision() == null) {
            return false;
        }
        if (other.getTargetRevision() != null && !other.getTargetRevision().equals(this.getTargetRevision())) {
            return false;
        }
        if (other.getTriggerConfigurations() == null ^ this.getTriggerConfigurations() == null) {
            return false;
        }
        if (other.getTriggerConfigurations() != null && !other.getTriggerConfigurations().equals(this.getTriggerConfigurations())) {
            return false;
        }
        if (other.getAlarmConfiguration() == null ^ this.getAlarmConfiguration() == null) {
            return false;
        }
        if (other.getAlarmConfiguration() != null && !other.getAlarmConfiguration().equals(this.getAlarmConfiguration())) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() == null ^ this.getAutoRollbackConfiguration() == null) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() != null && !other.getAutoRollbackConfiguration().equals(this.getAutoRollbackConfiguration())) {
            return false;
        }
        if (other.getDeploymentStyle() == null ^ this.getDeploymentStyle() == null) {
            return false;
        }
        if (other.getDeploymentStyle() != null && !other.getDeploymentStyle().equals(this.getDeploymentStyle())) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() == null ^ this.getBlueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() != null && !other.getBlueGreenDeploymentConfiguration().equals(this.getBlueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.getLoadBalancerInfo() == null ^ this.getLoadBalancerInfo() == null) {
            return false;
        }
        return other.getLoadBalancerInfo() == null || other.getLoadBalancerInfo().equals(this.getLoadBalancerInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupId() == null ? 0 : this.getDeploymentGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupName() == null ? 0 : this.getDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOnPremisesInstanceTagFilters() == null ? 0 : this.getOnPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRevision() == null ? 0 : this.getTargetRevision().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfigurations() == null ? 0 : this.getTriggerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmConfiguration() == null ? 0 : this.getAlarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRollbackConfiguration() == null ? 0 : this.getAutoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentStyle() == null ? 0 : this.getDeploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.getBlueGreenDeploymentConfiguration() == null ? 0 : this.getBlueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerInfo() == null ? 0 : this.getLoadBalancerInfo().hashCode());
        return hashCode;
    }

    public DeploymentGroupInfo clone() {
        try {
            return (DeploymentGroupInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentGroupInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

