/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.InstanceInfo;
import com.amazonaws.services.codedeploy.model.Tag;
import com.amazonaws.services.codedeploy.model.transform.TagJsonMarshaller;

public class InstanceInfoJsonMarshaller {
    private static InstanceInfoJsonMarshaller instance;

    public void marshall(InstanceInfo instanceInfo, StructuredJsonGenerator jsonGenerator) {
        if (instanceInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsList;
            jsonGenerator.writeStartObject();
            if (instanceInfo.getInstanceName() != null) {
                jsonGenerator.writeFieldName("instanceName").writeValue(instanceInfo.getInstanceName());
            }
            if (instanceInfo.getIamUserArn() != null) {
                jsonGenerator.writeFieldName("iamUserArn").writeValue(instanceInfo.getIamUserArn());
            }
            if (instanceInfo.getInstanceArn() != null) {
                jsonGenerator.writeFieldName("instanceArn").writeValue(instanceInfo.getInstanceArn());
            }
            if (instanceInfo.getRegisterTime() != null) {
                jsonGenerator.writeFieldName("registerTime").writeValue(instanceInfo.getRegisterTime());
            }
            if (instanceInfo.getDeregisterTime() != null) {
                jsonGenerator.writeFieldName("deregisterTime").writeValue(instanceInfo.getDeregisterTime());
            }
            if (!(tagsList = (SdkInternalList)instanceInfo.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceInfoJsonMarshaller();
        }
        return instance;
    }
}

