/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.GenericRevisionInfo;

public class GenericRevisionInfoJsonMarshaller {
    private static GenericRevisionInfoJsonMarshaller instance;

    public void marshall(GenericRevisionInfo genericRevisionInfo, StructuredJsonGenerator jsonGenerator) {
        if (genericRevisionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList deploymentGroupsList;
            jsonGenerator.writeStartObject();
            if (genericRevisionInfo.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(genericRevisionInfo.getDescription());
            }
            if (!(deploymentGroupsList = (SdkInternalList)genericRevisionInfo.getDeploymentGroups()).isEmpty() || !deploymentGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("deploymentGroups");
                jsonGenerator.writeStartArray();
                for (String deploymentGroupsListValue : deploymentGroupsList) {
                    if (deploymentGroupsListValue == null) continue;
                    jsonGenerator.writeValue(deploymentGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (genericRevisionInfo.getFirstUsedTime() != null) {
                jsonGenerator.writeFieldName("firstUsedTime").writeValue(genericRevisionInfo.getFirstUsedTime());
            }
            if (genericRevisionInfo.getLastUsedTime() != null) {
                jsonGenerator.writeFieldName("lastUsedTime").writeValue(genericRevisionInfo.getLastUsedTime());
            }
            if (genericRevisionInfo.getRegisterTime() != null) {
                jsonGenerator.writeFieldName("registerTime").writeValue(genericRevisionInfo.getRegisterTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GenericRevisionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GenericRevisionInfoJsonMarshaller();
        }
        return instance;
    }
}

