/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.RevisionLocation;

@SdkInternalApi
public class RevisionLocationMarshaller {
    private static final MarshallingInfo<String> REVISIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionType").build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final MarshallingInfo<StructuredPojo> GITHUBLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitHubLocation").build();
    private static final MarshallingInfo<StructuredPojo> STRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("string").build();
    private static final RevisionLocationMarshaller instance = new RevisionLocationMarshaller();

    public static RevisionLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(RevisionLocation revisionLocation, ProtocolMarshaller protocolMarshaller) {
        if (revisionLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)revisionLocation.getRevisionType(), REVISIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.getS3Location(), S3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.getGitHubLocation(), GITHUBLOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.getString(), STRING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

