/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.Alarm;
import com.amazonaws.services.codedeploy.model.transform.AlarmConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AlarmConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private Boolean ignorePollAlarmFailure;
    private SdkInternalList<Alarm> alarms;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public AlarmConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
        this.ignorePollAlarmFailure = ignorePollAlarmFailure;
    }

    public Boolean getIgnorePollAlarmFailure() {
        return this.ignorePollAlarmFailure;
    }

    public AlarmConfiguration withIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
        this.setIgnorePollAlarmFailure(ignorePollAlarmFailure);
        return this;
    }

    public Boolean isIgnorePollAlarmFailure() {
        return this.ignorePollAlarmFailure;
    }

    public List<Alarm> getAlarms() {
        if (this.alarms == null) {
            this.alarms = new SdkInternalList();
        }
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new SdkInternalList(alarms);
    }

    public AlarmConfiguration withAlarms(Alarm ... alarms) {
        if (this.alarms == null) {
            this.setAlarms((Collection<Alarm>)new SdkInternalList(alarms.length));
        }
        for (Alarm ele : alarms) {
            this.alarms.add((Object)ele);
        }
        return this;
    }

    public AlarmConfiguration withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getIgnorePollAlarmFailure() != null) {
            sb.append("IgnorePollAlarmFailure: ").append(this.getIgnorePollAlarmFailure()).append(",");
        }
        if (this.getAlarms() != null) {
            sb.append("Alarms: ").append(this.getAlarms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getIgnorePollAlarmFailure() == null ^ this.getIgnorePollAlarmFailure() == null) {
            return false;
        }
        if (other.getIgnorePollAlarmFailure() != null && !other.getIgnorePollAlarmFailure().equals(this.getIgnorePollAlarmFailure())) {
            return false;
        }
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        return other.getAlarms() == null || other.getAlarms().equals(this.getAlarms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getIgnorePollAlarmFailure() == null ? 0 : this.getIgnorePollAlarmFailure().hashCode());
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        return hashCode;
    }

    public AlarmConfiguration clone() {
        try {
            return (AlarmConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

