/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.transform.GitHubLocationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.S3LocationJsonMarshaller;

public class RevisionLocationJsonMarshaller {
    private static RevisionLocationJsonMarshaller instance;

    public void marshall(RevisionLocation revisionLocation, StructuredJsonGenerator jsonGenerator) {
        if (revisionLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (revisionLocation.getRevisionType() != null) {
                jsonGenerator.writeFieldName("revisionType").writeValue(revisionLocation.getRevisionType());
            }
            if (revisionLocation.getS3Location() != null) {
                jsonGenerator.writeFieldName("s3Location");
                S3LocationJsonMarshaller.getInstance().marshall(revisionLocation.getS3Location(), jsonGenerator);
            }
            if (revisionLocation.getGitHubLocation() != null) {
                jsonGenerator.writeFieldName("gitHubLocation");
                GitHubLocationJsonMarshaller.getInstance().marshall(revisionLocation.getGitHubLocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RevisionLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RevisionLocationJsonMarshaller();
        }
        return instance;
    }
}

