/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codedeploy.model.RawString;

@SdkInternalApi
public class RawStringMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("content").build();
    private static final MarshallingInfo<String> SHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sha256").build();
    private static final RawStringMarshaller instance = new RawStringMarshaller();

    public static RawStringMarshaller getInstance() {
        return instance;
    }

    public void marshall(RawString rawString, ProtocolMarshaller protocolMarshaller) {
        if (rawString == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rawString.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)rawString.getSha256(), SHA256_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

