/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.codedeploy.model.GetDeploymentResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class DeploymentSuccessful {
    DeploymentSuccessful() {
    }

    static class IsStoppedMatcher
    extends WaiterAcceptor<GetDeploymentResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppedMatcher() {
        }

        public boolean matches(GetDeploymentResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopped\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("deploymentInfo"), new JmesPathField("status")});
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<GetDeploymentResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        public boolean matches(GetDeploymentResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("deploymentInfo"), new JmesPathField("status")});
        }
    }

    static class IsSucceededMatcher
    extends WaiterAcceptor<GetDeploymentResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsSucceededMatcher() {
        }

        public boolean matches(GetDeploymentResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Succeeded\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("deploymentInfo"), new JmesPathField("status")});
        }
    }
}

