/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeploymentsResult
implements Serializable {
    private ListWithAutoConstructFlag<String> deployments;
    private String nextToken;

    public List<String> getDeployments() {
        if (this.deployments == null) {
            this.deployments = new ListWithAutoConstructFlag();
            this.deployments.setAutoConstruct(true);
        }
        return this.deployments;
    }

    public void setDeployments(Collection<String> deployments) {
        if (deployments == null) {
            this.deployments = null;
            return;
        }
        ListWithAutoConstructFlag deploymentsCopy = new ListWithAutoConstructFlag(deployments.size());
        deploymentsCopy.addAll(deployments);
        this.deployments = deploymentsCopy;
    }

    public ListDeploymentsResult withDeployments(String ... deployments) {
        if (this.getDeployments() == null) {
            this.setDeployments(new ArrayList<String>(deployments.length));
        }
        for (String value : deployments) {
            this.getDeployments().add(value);
        }
        return this;
    }

    public ListDeploymentsResult withDeployments(Collection<String> deployments) {
        if (deployments == null) {
            this.deployments = null;
        } else {
            ListWithAutoConstructFlag deploymentsCopy = new ListWithAutoConstructFlag(deployments.size());
            deploymentsCopy.addAll(deployments);
            this.deployments = deploymentsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDeploymentsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeployments() != null) {
            sb.append("Deployments: " + this.getDeployments() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeployments() == null ? 0 : this.getDeployments().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResult)) {
            return false;
        }
        ListDeploymentsResult other = (ListDeploymentsResult)obj;
        if (other.getDeployments() == null ^ this.getDeployments() == null) {
            return false;
        }
        if (other.getDeployments() != null && !other.getDeployments().equals(this.getDeployments())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

