/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String deploymentGroupName;
    private String deploymentConfigName;
    private ListWithAutoConstructFlag<EC2TagFilter> ec2TagFilters;
    private ListWithAutoConstructFlag<String> autoScalingGroups;
    private String serviceRoleArn;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public CreateDeploymentGroupRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public void setDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
    }

    public CreateDeploymentGroupRequest withDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
        return this;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public CreateDeploymentGroupRequest withDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new ListWithAutoConstructFlag();
            this.ec2TagFilters.setAutoConstruct(true);
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
        ec2TagFiltersCopy.addAll(ec2TagFilters);
        this.ec2TagFilters = ec2TagFiltersCopy;
    }

    public CreateDeploymentGroupRequest withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.getEc2TagFilters() == null) {
            this.setEc2TagFilters(new ArrayList<EC2TagFilter>(ec2TagFilters.length));
        }
        for (EC2TagFilter value : ec2TagFilters) {
            this.getEc2TagFilters().add(value);
        }
        return this;
    }

    public CreateDeploymentGroupRequest withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
        } else {
            ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
            ec2TagFiltersCopy.addAll(ec2TagFilters);
            this.ec2TagFilters = ec2TagFiltersCopy;
        }
        return this;
    }

    public List<String> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new ListWithAutoConstructFlag();
            this.autoScalingGroups.setAutoConstruct(true);
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
        autoScalingGroupsCopy.addAll(autoScalingGroups);
        this.autoScalingGroups = autoScalingGroupsCopy;
    }

    public CreateDeploymentGroupRequest withAutoScalingGroups(String ... autoScalingGroups) {
        if (this.getAutoScalingGroups() == null) {
            this.setAutoScalingGroups(new ArrayList<String>(autoScalingGroups.length));
        }
        for (String value : autoScalingGroups) {
            this.getAutoScalingGroups().add(value);
        }
        return this;
    }

    public CreateDeploymentGroupRequest withAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
        } else {
            ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
            autoScalingGroupsCopy.addAll(autoScalingGroups);
            this.autoScalingGroups = autoScalingGroupsCopy;
        }
        return this;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public CreateDeploymentGroupRequest withServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getDeploymentGroupName() != null) {
            sb.append("DeploymentGroupName: " + this.getDeploymentGroupName() + ",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: " + this.getDeploymentConfigName() + ",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: " + this.getEc2TagFilters() + ",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: " + this.getAutoScalingGroups() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupName() == null ? 0 : this.getDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentGroupRequest)) {
            return false;
        }
        CreateDeploymentGroupRequest other = (CreateDeploymentGroupRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroupName() == null ^ this.getDeploymentGroupName() == null) {
            return false;
        }
        if (other.getDeploymentGroupName() != null && !other.getDeploymentGroupName().equals(this.getDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        return other.getServiceRoleArn() == null || other.getServiceRoleArn().equals(this.getServiceRoleArn());
    }

    public CreateDeploymentGroupRequest clone() {
        return (CreateDeploymentGroupRequest)super.clone();
    }
}

