/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InstanceInfo
implements Serializable,
Cloneable {
    private String instanceName;
    private String iamUserArn;
    private String instanceArn;
    private Date registerTime;
    private Date deregisterTime;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public InstanceInfo withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getIamUserArn() {
        return this.iamUserArn;
    }

    public void setIamUserArn(String iamUserArn) {
        this.iamUserArn = iamUserArn;
    }

    public InstanceInfo withIamUserArn(String iamUserArn) {
        this.iamUserArn = iamUserArn;
        return this;
    }

    public String getInstanceArn() {
        return this.instanceArn;
    }

    public void setInstanceArn(String instanceArn) {
        this.instanceArn = instanceArn;
    }

    public InstanceInfo withInstanceArn(String instanceArn) {
        this.instanceArn = instanceArn;
        return this;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public InstanceInfo withRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
        return this;
    }

    public Date getDeregisterTime() {
        return this.deregisterTime;
    }

    public void setDeregisterTime(Date deregisterTime) {
        this.deregisterTime = deregisterTime;
    }

    public InstanceInfo withDeregisterTime(Date deregisterTime) {
        this.deregisterTime = deregisterTime;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public InstanceInfo withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public InstanceInfo withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceName() != null) {
            sb.append("InstanceName: " + this.getInstanceName() + ",");
        }
        if (this.getIamUserArn() != null) {
            sb.append("IamUserArn: " + this.getIamUserArn() + ",");
        }
        if (this.getInstanceArn() != null) {
            sb.append("InstanceArn: " + this.getInstanceArn() + ",");
        }
        if (this.getRegisterTime() != null) {
            sb.append("RegisterTime: " + this.getRegisterTime() + ",");
        }
        if (this.getDeregisterTime() != null) {
            sb.append("DeregisterTime: " + this.getDeregisterTime() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceName() == null ? 0 : this.getInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getIamUserArn() == null ? 0 : this.getIamUserArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceArn() == null ? 0 : this.getInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegisterTime() == null ? 0 : this.getRegisterTime().hashCode());
        hashCode = 31 * hashCode + (this.getDeregisterTime() == null ? 0 : this.getDeregisterTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        if (other.getInstanceName() == null ^ this.getInstanceName() == null) {
            return false;
        }
        if (other.getInstanceName() != null && !other.getInstanceName().equals(this.getInstanceName())) {
            return false;
        }
        if (other.getIamUserArn() == null ^ this.getIamUserArn() == null) {
            return false;
        }
        if (other.getIamUserArn() != null && !other.getIamUserArn().equals(this.getIamUserArn())) {
            return false;
        }
        if (other.getInstanceArn() == null ^ this.getInstanceArn() == null) {
            return false;
        }
        if (other.getInstanceArn() != null && !other.getInstanceArn().equals(this.getInstanceArn())) {
            return false;
        }
        if (other.getRegisterTime() == null ^ this.getRegisterTime() == null) {
            return false;
        }
        if (other.getRegisterTime() != null && !other.getRegisterTime().equals(this.getRegisterTime())) {
            return false;
        }
        if (other.getDeregisterTime() == null ^ this.getDeregisterTime() == null) {
            return false;
        }
        if (other.getDeregisterTime() != null && !other.getDeregisterTime().equals(this.getDeregisterTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public InstanceInfo clone() {
        try {
            return (InstanceInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

