/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GenericRevisionInfo
implements Serializable {
    private String description;
    private ListWithAutoConstructFlag<String> deploymentGroups;
    private Date firstUsedTime;
    private Date lastUsedTime;
    private Date registerTime;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GenericRevisionInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getDeploymentGroups() {
        if (this.deploymentGroups == null) {
            this.deploymentGroups = new ListWithAutoConstructFlag();
            this.deploymentGroups.setAutoConstruct(true);
        }
        return this.deploymentGroups;
    }

    public void setDeploymentGroups(Collection<String> deploymentGroups) {
        if (deploymentGroups == null) {
            this.deploymentGroups = null;
            return;
        }
        ListWithAutoConstructFlag deploymentGroupsCopy = new ListWithAutoConstructFlag(deploymentGroups.size());
        deploymentGroupsCopy.addAll(deploymentGroups);
        this.deploymentGroups = deploymentGroupsCopy;
    }

    public GenericRevisionInfo withDeploymentGroups(String ... deploymentGroups) {
        if (this.getDeploymentGroups() == null) {
            this.setDeploymentGroups(new ArrayList<String>(deploymentGroups.length));
        }
        for (String value : deploymentGroups) {
            this.getDeploymentGroups().add(value);
        }
        return this;
    }

    public GenericRevisionInfo withDeploymentGroups(Collection<String> deploymentGroups) {
        if (deploymentGroups == null) {
            this.deploymentGroups = null;
        } else {
            ListWithAutoConstructFlag deploymentGroupsCopy = new ListWithAutoConstructFlag(deploymentGroups.size());
            deploymentGroupsCopy.addAll(deploymentGroups);
            this.deploymentGroups = deploymentGroupsCopy;
        }
        return this;
    }

    public Date getFirstUsedTime() {
        return this.firstUsedTime;
    }

    public void setFirstUsedTime(Date firstUsedTime) {
        this.firstUsedTime = firstUsedTime;
    }

    public GenericRevisionInfo withFirstUsedTime(Date firstUsedTime) {
        this.firstUsedTime = firstUsedTime;
        return this;
    }

    public Date getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(Date lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public GenericRevisionInfo withLastUsedTime(Date lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
        return this;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public GenericRevisionInfo withRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDeploymentGroups() != null) {
            sb.append("DeploymentGroups: " + this.getDeploymentGroups() + ",");
        }
        if (this.getFirstUsedTime() != null) {
            sb.append("FirstUsedTime: " + this.getFirstUsedTime() + ",");
        }
        if (this.getLastUsedTime() != null) {
            sb.append("LastUsedTime: " + this.getLastUsedTime() + ",");
        }
        if (this.getRegisterTime() != null) {
            sb.append("RegisterTime: " + this.getRegisterTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroups() == null ? 0 : this.getDeploymentGroups().hashCode());
        hashCode = 31 * hashCode + (this.getFirstUsedTime() == null ? 0 : this.getFirstUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUsedTime() == null ? 0 : this.getLastUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.getRegisterTime() == null ? 0 : this.getRegisterTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericRevisionInfo)) {
            return false;
        }
        GenericRevisionInfo other = (GenericRevisionInfo)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDeploymentGroups() == null ^ this.getDeploymentGroups() == null) {
            return false;
        }
        if (other.getDeploymentGroups() != null && !other.getDeploymentGroups().equals(this.getDeploymentGroups())) {
            return false;
        }
        if (other.getFirstUsedTime() == null ^ this.getFirstUsedTime() == null) {
            return false;
        }
        if (other.getFirstUsedTime() != null && !other.getFirstUsedTime().equals(this.getFirstUsedTime())) {
            return false;
        }
        if (other.getLastUsedTime() == null ^ this.getLastUsedTime() == null) {
            return false;
        }
        if (other.getLastUsedTime() != null && !other.getLastUsedTime().equals(this.getLastUsedTime())) {
            return false;
        }
        if (other.getRegisterTime() == null ^ this.getRegisterTime() == null) {
            return false;
        }
        return other.getRegisterTime() == null || other.getRegisterTime().equals(this.getRegisterTime());
    }
}

