/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReplicationGroupShardConfigurationRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupShardConfigurationRequest>, ModifyReplicationGroupShardConfigurationRequest> {
    public Request<ModifyReplicationGroupShardConfigurationRequest> marshall(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        if (modifyReplicationGroupShardConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReplicationGroupShardConfigurationRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyReplicationGroupShardConfiguration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringUtils.fromInteger((Integer)modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyReplicationGroupShardConfigurationRequest.getApplyImmediately()));
        }
        if (!modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration().isEmpty() || !((SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration()).isAutoConstruct()) {
            SdkInternalList reshardingConfigurationList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration();
            int reshardingConfigurationListIndex = 1;
            for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                if (reshardingConfigurationListValue.getNodeGroupId() != null) {
                    request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".NodeGroupId", StringUtils.fromString((String)reshardingConfigurationListValue.getNodeGroupId()));
                }
                if (!reshardingConfigurationListValue.getPreferredAvailabilityZones().isEmpty() || !((SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones()).isAutoConstruct()) {
                    SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++reshardingConfigurationListIndex;
            }
        }
        if (!modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove().isEmpty() || !((SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove()).isAutoConstruct()) {
            SdkInternalList nodeGroupsToRemoveList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove();
            int nodeGroupsToRemoveListIndex = 1;
            for (String nodeGroupsToRemoveListValue : nodeGroupsToRemoveList) {
                if (nodeGroupsToRemoveListValue != null) {
                    request.addParameter("NodeGroupsToRemove.NodeGroupToRemove." + nodeGroupsToRemoveListIndex, StringUtils.fromString((String)nodeGroupsToRemoveListValue));
                }
                ++nodeGroupsToRemoveListIndex;
            }
        }
        if (!modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRetain().isEmpty() || !((SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRetain()).isAutoConstruct()) {
            SdkInternalList nodeGroupsToRetainList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRetain();
            int nodeGroupsToRetainListIndex = 1;
            for (String nodeGroupsToRetainListValue : nodeGroupsToRetainList) {
                if (nodeGroupsToRetainListValue != null) {
                    request.addParameter("NodeGroupsToRetain.NodeGroupToRetain." + nodeGroupsToRetainListIndex, StringUtils.fromString((String)nodeGroupsToRetainListValue));
                }
                ++nodeGroupsToRetainListIndex;
            }
        }
        return request;
    }
}

