/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.Captions;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionFormatJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionSourceJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CaptionsJsonMarshaller {
    private static CaptionsJsonMarshaller instance;

    public void marshall(Captions captions, JSONWriter jsonWriter) {
        if (captions == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList captionFormatsList;
            SdkInternalList captionSourcesList;
            jsonWriter.object();
            if (captions.getMergePolicy() != null) {
                jsonWriter.key("MergePolicy").value((Object)captions.getMergePolicy());
            }
            if (!(captionSourcesList = (SdkInternalList)captions.getCaptionSources()).isEmpty() || !captionSourcesList.isAutoConstruct()) {
                jsonWriter.key("CaptionSources");
                jsonWriter.array();
                for (CaptionSource captionSourcesListValue : captionSourcesList) {
                    if (captionSourcesListValue == null) continue;
                    CaptionSourceJsonMarshaller.getInstance().marshall(captionSourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(captionFormatsList = (SdkInternalList)captions.getCaptionFormats()).isEmpty() || !captionFormatsList.isAutoConstruct()) {
                jsonWriter.key("CaptionFormats");
                jsonWriter.array();
                for (CaptionFormat captionFormatsListValue : captionFormatsList) {
                    if (captionFormatsListValue == null) continue;
                    CaptionFormatJsonMarshaller.getInstance().marshall(captionFormatsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionsJsonMarshaller();
        }
        return instance;
    }
}

