/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.transform.AudioParametersJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ThumbnailsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.VideoParametersJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePresetRequestMarshaller
implements Marshaller<Request<CreatePresetRequest>, CreatePresetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreatePresetRequest> marshall(CreatePresetRequest createPresetRequest) {
        if (createPresetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPresetRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/presets";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createPresetRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createPresetRequest.getName());
            }
            if (createPresetRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)createPresetRequest.getDescription());
            }
            if (createPresetRequest.getContainer() != null) {
                jsonWriter.key("Container").value((Object)createPresetRequest.getContainer());
            }
            if (createPresetRequest.getVideo() != null) {
                jsonWriter.key("Video");
                VideoParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getVideo(), jsonWriter);
            }
            if (createPresetRequest.getAudio() != null) {
                jsonWriter.key("Audio");
                AudioParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getAudio(), jsonWriter);
            }
            if (createPresetRequest.getThumbnails() != null) {
                jsonWriter.key("Thumbnails");
                ThumbnailsJsonMarshaller.getInstance().marshall(createPresetRequest.getThumbnails(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

