/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ReadPresetRequestMarshaller
implements Marshaller<Request<ReadPresetRequest>, ReadPresetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ReadPresetRequest> marshall(ReadPresetRequest readPresetRequest) {
        if (readPresetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)readPresetRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/presets/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", readPresetRequest.getId() != null ? StringUtils.fromString((String)readPresetRequest.getId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

