/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.AudioParameters;
import com.amazonaws.services.elastictranscoder.model.transform.AudioCodecOptionsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class AudioParametersJsonMarshaller {
    private static AudioParametersJsonMarshaller instance;

    public void marshall(AudioParameters audioParameters, SdkJsonGenerator jsonGenerator) {
        if (audioParameters == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (audioParameters.getCodec() != null) {
                jsonGenerator.writeFieldName("Codec").writeValue(audioParameters.getCodec());
            }
            if (audioParameters.getSampleRate() != null) {
                jsonGenerator.writeFieldName("SampleRate").writeValue(audioParameters.getSampleRate());
            }
            if (audioParameters.getBitRate() != null) {
                jsonGenerator.writeFieldName("BitRate").writeValue(audioParameters.getBitRate());
            }
            if (audioParameters.getChannels() != null) {
                jsonGenerator.writeFieldName("Channels").writeValue(audioParameters.getChannels());
            }
            if (audioParameters.getAudioPackingMode() != null) {
                jsonGenerator.writeFieldName("AudioPackingMode").writeValue(audioParameters.getAudioPackingMode());
            }
            if (audioParameters.getCodecOptions() != null) {
                jsonGenerator.writeFieldName("CodecOptions");
                AudioCodecOptionsJsonMarshaller.getInstance().marshall(audioParameters.getCodecOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AudioParametersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AudioParametersJsonMarshaller();
        }
        return instance;
    }
}

