/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.PresetWatermark;
import com.amazonaws.services.elastictranscoder.model.VideoParameters;
import com.amazonaws.services.elastictranscoder.model.transform.PresetWatermarkJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class VideoParametersJsonMarshaller {
    private static VideoParametersJsonMarshaller instance;

    public void marshall(VideoParameters videoParameters, StructuredJsonGenerator jsonGenerator) {
        if (videoParameters == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList watermarksList;
            SdkInternalMap codecOptionsMap;
            jsonGenerator.writeStartObject();
            if (videoParameters.getCodec() != null) {
                jsonGenerator.writeFieldName("Codec").writeValue(videoParameters.getCodec());
            }
            if (!(codecOptionsMap = (SdkInternalMap)videoParameters.getCodecOptions()).isEmpty() || !codecOptionsMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CodecOptions");
                jsonGenerator.writeStartObject();
                for (Map.Entry codecOptionsMapValue : codecOptionsMap.entrySet()) {
                    if (codecOptionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)codecOptionsMapValue.getKey());
                    jsonGenerator.writeValue((String)codecOptionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (videoParameters.getKeyframesMaxDist() != null) {
                jsonGenerator.writeFieldName("KeyframesMaxDist").writeValue(videoParameters.getKeyframesMaxDist());
            }
            if (videoParameters.getFixedGOP() != null) {
                jsonGenerator.writeFieldName("FixedGOP").writeValue(videoParameters.getFixedGOP());
            }
            if (videoParameters.getBitRate() != null) {
                jsonGenerator.writeFieldName("BitRate").writeValue(videoParameters.getBitRate());
            }
            if (videoParameters.getFrameRate() != null) {
                jsonGenerator.writeFieldName("FrameRate").writeValue(videoParameters.getFrameRate());
            }
            if (videoParameters.getMaxFrameRate() != null) {
                jsonGenerator.writeFieldName("MaxFrameRate").writeValue(videoParameters.getMaxFrameRate());
            }
            if (videoParameters.getResolution() != null) {
                jsonGenerator.writeFieldName("Resolution").writeValue(videoParameters.getResolution());
            }
            if (videoParameters.getAspectRatio() != null) {
                jsonGenerator.writeFieldName("AspectRatio").writeValue(videoParameters.getAspectRatio());
            }
            if (videoParameters.getMaxWidth() != null) {
                jsonGenerator.writeFieldName("MaxWidth").writeValue(videoParameters.getMaxWidth());
            }
            if (videoParameters.getMaxHeight() != null) {
                jsonGenerator.writeFieldName("MaxHeight").writeValue(videoParameters.getMaxHeight());
            }
            if (videoParameters.getDisplayAspectRatio() != null) {
                jsonGenerator.writeFieldName("DisplayAspectRatio").writeValue(videoParameters.getDisplayAspectRatio());
            }
            if (videoParameters.getSizingPolicy() != null) {
                jsonGenerator.writeFieldName("SizingPolicy").writeValue(videoParameters.getSizingPolicy());
            }
            if (videoParameters.getPaddingPolicy() != null) {
                jsonGenerator.writeFieldName("PaddingPolicy").writeValue(videoParameters.getPaddingPolicy());
            }
            if (!(watermarksList = (SdkInternalList)videoParameters.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Watermarks");
                jsonGenerator.writeStartArray();
                for (PresetWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    PresetWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VideoParametersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VideoParametersJsonMarshaller();
        }
        return instance;
    }
}

