/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.Warning;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePipelineResult
implements Serializable,
Cloneable {
    private Pipeline pipeline;
    private SdkInternalList<Warning> warnings;

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public CreatePipelineResult withPipeline(Pipeline pipeline) {
        this.setPipeline(pipeline);
        return this;
    }

    public List<Warning> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new SdkInternalList();
        }
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new SdkInternalList(warnings);
    }

    public CreatePipelineResult withWarnings(Warning ... warnings) {
        if (this.warnings == null) {
            this.setWarnings((Collection<Warning>)new SdkInternalList(warnings.length));
        }
        for (Warning ele : warnings) {
            this.warnings.add((Object)ele);
        }
        return this;
    }

    public CreatePipelineResult withWarnings(Collection<Warning> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipeline() != null) {
            sb.append("Pipeline: " + this.getPipeline() + ",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: " + this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineResult)) {
            return false;
        }
        CreatePipelineResult other = (CreatePipelineResult)obj;
        if (other.getPipeline() == null ^ this.getPipeline() == null) {
            return false;
        }
        if (other.getPipeline() != null && !other.getPipeline().equals(this.getPipeline())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipeline() == null ? 0 : this.getPipeline().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public CreatePipelineResult clone() {
        try {
            return (CreatePipelineResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

