/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.transform.AudioParametersJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ThumbnailsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.VideoParametersJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePresetRequestMarshaller
implements Marshaller<Request<CreatePresetRequest>, CreatePresetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreatePresetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreatePresetRequest> marshall(CreatePresetRequest createPresetRequest) {
        if (createPresetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPresetRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/presets";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPresetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createPresetRequest.getName());
            }
            if (createPresetRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createPresetRequest.getDescription());
            }
            if (createPresetRequest.getContainer() != null) {
                jsonGenerator.writeFieldName("Container").writeValue(createPresetRequest.getContainer());
            }
            if (createPresetRequest.getVideo() != null) {
                jsonGenerator.writeFieldName("Video");
                VideoParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getVideo(), jsonGenerator);
            }
            if (createPresetRequest.getAudio() != null) {
                jsonGenerator.writeFieldName("Audio");
                AudioParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getAudio(), jsonGenerator);
            }
            if (createPresetRequest.getThumbnails() != null) {
                jsonGenerator.writeFieldName("Thumbnails");
                ThumbnailsJsonMarshaller.getInstance().marshall(createPresetRequest.getThumbnails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

