/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.transform.DetectedPropertiesJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;

public class JobInputJsonMarshaller {
    private static JobInputJsonMarshaller instance;

    public void marshall(JobInput jobInput, StructuredJsonGenerator jsonGenerator) {
        if (jobInput == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (jobInput.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(jobInput.getKey());
            }
            if (jobInput.getFrameRate() != null) {
                jsonGenerator.writeFieldName("FrameRate").writeValue(jobInput.getFrameRate());
            }
            if (jobInput.getResolution() != null) {
                jsonGenerator.writeFieldName("Resolution").writeValue(jobInput.getResolution());
            }
            if (jobInput.getAspectRatio() != null) {
                jsonGenerator.writeFieldName("AspectRatio").writeValue(jobInput.getAspectRatio());
            }
            if (jobInput.getInterlaced() != null) {
                jsonGenerator.writeFieldName("Interlaced").writeValue(jobInput.getInterlaced());
            }
            if (jobInput.getContainer() != null) {
                jsonGenerator.writeFieldName("Container").writeValue(jobInput.getContainer());
            }
            if (jobInput.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobInput.getEncryption(), jsonGenerator);
            }
            if (jobInput.getDetectedProperties() != null) {
                jsonGenerator.writeFieldName("DetectedProperties");
                DetectedPropertiesJsonMarshaller.getInstance().marshall(jobInput.getDetectedProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobInputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobInputJsonMarshaller();
        }
        return instance;
    }
}

