/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Job;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import com.amazonaws.services.elastictranscoder.model.transform.JobInputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobOutputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PlaylistJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TimingJsonMarshaller;
import java.util.Map;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, StructuredJsonGenerator jsonGenerator) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap userMetadataMap;
            SdkInternalList playlistsList;
            SdkInternalList outputsList;
            jsonGenerator.writeStartObject();
            if (job.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(job.getId());
            }
            if (job.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(job.getArn());
            }
            if (job.getPipelineId() != null) {
                jsonGenerator.writeFieldName("PipelineId").writeValue(job.getPipelineId());
            }
            if (job.getInput() != null) {
                jsonGenerator.writeFieldName("Input");
                JobInputJsonMarshaller.getInstance().marshall(job.getInput(), jsonGenerator);
            }
            if (job.getOutput() != null) {
                jsonGenerator.writeFieldName("Output");
                JobOutputJsonMarshaller.getInstance().marshall(job.getOutput(), jsonGenerator);
            }
            if (!(outputsList = (SdkInternalList)job.getOutputs()).isEmpty() || !outputsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Outputs");
                jsonGenerator.writeStartArray();
                for (JobOutput outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    JobOutputJsonMarshaller.getInstance().marshall(outputsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (job.getOutputKeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputKeyPrefix").writeValue(job.getOutputKeyPrefix());
            }
            if (!(playlistsList = (SdkInternalList)job.getPlaylists()).isEmpty() || !playlistsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Playlists");
                jsonGenerator.writeStartArray();
                for (Playlist playlistsListValue : playlistsList) {
                    if (playlistsListValue == null) continue;
                    PlaylistJsonMarshaller.getInstance().marshall(playlistsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (job.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(job.getStatus());
            }
            if (!(userMetadataMap = (SdkInternalMap)job.getUserMetadata()).isEmpty() || !userMetadataMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("UserMetadata");
                jsonGenerator.writeStartObject();
                for (Map.Entry userMetadataMapValue : userMetadataMap.entrySet()) {
                    if (userMetadataMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)userMetadataMapValue.getKey());
                    jsonGenerator.writeValue((String)userMetadataMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (job.getTiming() != null) {
                jsonGenerator.writeFieldName("Timing");
                TimingJsonMarshaller.getInstance().marshall(job.getTiming(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

