/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ReadJobRequestMarshaller
implements Marshaller<Request<ReadJobRequest>, ReadJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ReadJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ReadJobRequest> marshall(ReadJobRequest readJobRequest) {
        if (readJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)readJobRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/jobs/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", readJobRequest.getId());
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

