/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Permission;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PipelineOutputConfig
implements Serializable,
Cloneable {
    private String bucket;
    private String storageClass;
    private SdkInternalList<Permission> permissions;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public PipelineOutputConfig withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public PipelineOutputConfig withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new SdkInternalList();
        }
        return this.permissions;
    }

    public void setPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new SdkInternalList(permissions);
    }

    public PipelineOutputConfig withPermissions(Permission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions((Collection<Permission>)new SdkInternalList(permissions.length));
        }
        for (Permission ele : permissions) {
            this.permissions.add((Object)ele);
        }
        return this;
    }

    public PipelineOutputConfig withPermissions(Collection<Permission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineOutputConfig)) {
            return false;
        }
        PipelineOutputConfig other = (PipelineOutputConfig)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        if (other.getStorageClass() != null && !other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public PipelineOutputConfig clone() {
        try {
            return (PipelineOutputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

