/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ClipJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobAlbumArtJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobWatermarkJsonMarshaller;

public class CreateJobOutputJsonMarshaller {
    private static CreateJobOutputJsonMarshaller instance;

    public void marshall(CreateJobOutput createJobOutput, StructuredJsonGenerator jsonGenerator) {
        if (createJobOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList compositionList;
            SdkInternalList watermarksList;
            jsonGenerator.writeStartObject();
            if (createJobOutput.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(createJobOutput.getKey());
            }
            if (createJobOutput.getThumbnailPattern() != null) {
                jsonGenerator.writeFieldName("ThumbnailPattern").writeValue(createJobOutput.getThumbnailPattern());
            }
            if (createJobOutput.getThumbnailEncryption() != null) {
                jsonGenerator.writeFieldName("ThumbnailEncryption");
                EncryptionJsonMarshaller.getInstance().marshall(createJobOutput.getThumbnailEncryption(), jsonGenerator);
            }
            if (createJobOutput.getRotate() != null) {
                jsonGenerator.writeFieldName("Rotate").writeValue(createJobOutput.getRotate());
            }
            if (createJobOutput.getPresetId() != null) {
                jsonGenerator.writeFieldName("PresetId").writeValue(createJobOutput.getPresetId());
            }
            if (createJobOutput.getSegmentDuration() != null) {
                jsonGenerator.writeFieldName("SegmentDuration").writeValue(createJobOutput.getSegmentDuration());
            }
            if (!(watermarksList = (SdkInternalList)createJobOutput.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Watermarks");
                jsonGenerator.writeStartArray();
                for (JobWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    JobWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createJobOutput.getAlbumArt() != null) {
                jsonGenerator.writeFieldName("AlbumArt");
                JobAlbumArtJsonMarshaller.getInstance().marshall(createJobOutput.getAlbumArt(), jsonGenerator);
            }
            if (!(compositionList = (SdkInternalList)createJobOutput.getComposition()).isEmpty() || !compositionList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Composition");
                jsonGenerator.writeStartArray();
                for (Clip compositionListValue : compositionList) {
                    if (compositionListValue == null) continue;
                    ClipJsonMarshaller.getInstance().marshall(compositionListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createJobOutput.getCaptions() != null) {
                jsonGenerator.writeFieldName("Captions");
                CaptionsJsonMarshaller.getInstance().marshall(createJobOutput.getCaptions(), jsonGenerator);
            }
            if (createJobOutput.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(createJobOutput.getEncryption(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CreateJobOutputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CreateJobOutputJsonMarshaller();
        }
        return instance;
    }
}

