/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.waiters.JobComplete;
import com.amazonaws.services.elastictranscoder.waiters.ReadJobFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonElasticTranscoderWaiters {
    private final AmazonElasticTranscoder client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonElasticTranscoderWaiters(AmazonElasticTranscoder client) {
        this.client = client;
    }

    public Waiter<ReadJobRequest> jobComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new ReadJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new JobComplete.IsCompleteMatcher(), new JobComplete.IsCanceledMatcher(), new JobComplete.IsErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

