/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cloudwatchevents.model.Replay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListReplaysResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Replay> replays;
    private String nextToken;

    public List<Replay> getReplays() {
        return this.replays;
    }

    public void setReplays(Collection<Replay> replays) {
        if (replays == null) {
            this.replays = null;
            return;
        }
        this.replays = new ArrayList<Replay>(replays);
    }

    public ListReplaysResult withReplays(Replay ... replays) {
        if (this.replays == null) {
            this.setReplays(new ArrayList<Replay>(replays.length));
        }
        for (Replay ele : replays) {
            this.replays.add(ele);
        }
        return this;
    }

    public ListReplaysResult withReplays(Collection<Replay> replays) {
        this.setReplays(replays);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListReplaysResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplays() != null) {
            sb.append("Replays: ").append(this.getReplays()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplaysResult)) {
            return false;
        }
        ListReplaysResult other = (ListReplaysResult)obj;
        if (other.getReplays() == null ^ this.getReplays() == null) {
            return false;
        }
        if (other.getReplays() != null && !other.getReplays().equals(this.getReplays())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplays() == null ? 0 : this.getReplays().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListReplaysResult clone() {
        try {
            return (ListReplaysResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

