/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples;

import com.amazonaws.codegen.emitters.JavaCodeFormatter;
import com.amazonaws.codegen.model.intermediate.Example;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.ListModel;
import com.amazonaws.codegen.model.intermediate.MapModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.samples.exception.SampleGenerationException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class SamplesGenerator {
    private final IntermediateModel model;
    private final StringBuilder sb;
    private final JavaCodeFormatter formatter;

    public SamplesGenerator(IntermediateModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Intermediate model must be provided");
        }
        this.model = model;
        this.sb = new StringBuilder();
        HashMap<String, Boolean> formatterOptions = new HashMap<String, Boolean>();
        formatterOptions.put("org.eclipse.jdt.core.formatter.comment.format_line_comments", false);
        this.formatter = new JavaCodeFormatter(formatterOptions);
    }

    public String getGeneratedSamples() throws SampleGenerationException {
        String serviceName = this.model.getMetadata().getSyncInterface();
        String packageName = this.model.getMetadata().getPackageName();
        this.writeLine(String.format("import %s.*;", packageName));
        this.writeLine(String.format("import %s.model.*;\n", packageName));
        this.writeLine("import java.nio.*;\n");
        this.writeLine(String.format("public class %sGeneratedSamples {", serviceName));
        this.model.getExamples().getOperationExamples().forEach((k, v) -> this.emitCode(serviceName, (String)k, (List<Example>)v));
        this.writeLine("}");
        return this.formatter.format(this.sb.toString());
    }

    private void emitCode(String serviceName, String operationName, List<Example> examples) {
        Metadata metadata = this.model.getMetadata();
        OperationModel operationModel = (OperationModel)this.model.getOperations().get(operationName);
        if (operationModel == null) {
            throw new IllegalArgumentException("Could not retrieve operation model for operation " + operationName);
        }
        String operationMethodName = operationModel.getMethodName();
        String inputType = operationModel.getInput().getVariableType();
        ShapeModel inputModel = (ShapeModel)this.model.getShapes().get(inputType);
        for (int i = 0; i < examples.size(); ++i) {
            Example example = examples.get(i);
            this.writeLine(String.format("public void %s_%s() {", operationName, i + 1));
            this.writeLine(String.format("//BEGIN_SAMPLE:%s.%s", serviceName, operationName));
            this.writeLine("//TITLE:" + example.getTitle());
            this.writeLine("//DESCRIPTION:" + example.getDescription());
            this.writeLine(String.format("%s client = new %s();", metadata.getSyncInterface(), metadata.getSyncClient()));
            this.writeLine(String.format("%1$s request = new %1$s()", inputType));
            this.getRequestAssignments(example.getInput(), inputModel, example.getComments().getInputComments());
            if (operationModel.getReturnType() != null) {
                String returnType = operationModel.getReturnType().getReturnType();
                this.writeLine(String.format("%s response = client.%s(request);", returnType, operationMethodName));
            } else {
                this.writeLine(String.format("client.%s(request);", operationMethodName));
            }
            this.writeLine("//END_SAMPLE");
            this.writeLine("}");
        }
    }

    private void getRequestAssignments(JsonNode node, ShapeModel inputModel, Map<String, String> comments) {
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            MemberModel memberModel = inputModel.findMemberModelByC2jName(fieldName);
            StringBuilder assignmentValue = new StringBuilder();
            this.getAssignmentValue(assignmentValue, node.get(fieldName), memberModel);
            if (comments.containsKey(fieldName)) {
                this.writeLine("//" + comments.get(fieldName));
            }
            if (memberModel.isList()) {
                this.sb.append(String.format(".with%s(%s)", this.firstCharToUpper(fieldName), assignmentValue.toString()));
                continue;
            }
            if (memberModel.isMap()) {
                this.sb.append(assignmentValue.toString());
                continue;
            }
            this.sb.append(String.format(".with%s(%s)", this.firstCharToUpper(fieldName), assignmentValue.toString()));
        }
        this.sb.append(";\n");
    }

    private void getAssignmentValue(StringBuilder sb, JsonNode node, MemberModel memberModel) {
        if (memberModel.isSimple()) {
            sb.append(this.formatPrimitiveValue(memberModel.getSetterModel().getSimpleType(), node.asText()));
        } else if (memberModel.isList()) {
            ListModel listModel = memberModel.getListModel();
            Iterator iter = node.iterator();
            while (iter.hasNext()) {
                JsonNode entry = (JsonNode)iter.next();
                if (listModel.getListMemberModel() == null) {
                    sb.append(this.formatPrimitiveValue(listModel.getMemberType(), entry.asText()));
                } else {
                    this.getAssignmentValue(sb, entry, listModel.getListMemberModel());
                }
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        } else if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            Iterator iter = node.fields();
            while (iter.hasNext()) {
                Map.Entry field = (Map.Entry)iter.next();
                JsonNode curNode = (JsonNode)field.getValue();
                sb.append(String.format(".add%sEntry(", this.firstCharToUpper(memberModel.getC2jName())));
                sb.append(this.formatPrimitiveValue(mapModel.getKeyType(), (String)field.getKey()));
                sb.append(", ");
                if (mapModel.getValueModel() == null) {
                    sb.append(this.formatPrimitiveValue(mapModel.getValueType(), curNode.asText()));
                } else {
                    this.getAssignmentValue(sb, curNode, mapModel.getValueModel());
                }
                sb.append(")");
            }
        } else {
            sb.append(String.format("new %s()", memberModel.getC2jShape()));
            Iterator iter = node.fields();
            ShapeModel memberShape = (ShapeModel)this.model.getShapes().get(memberModel.getC2jShape());
            while (iter.hasNext()) {
                Map.Entry field = (Map.Entry)iter.next();
                MemberModel fieldMemberModel = memberShape.getMemberByC2jName((String)field.getKey());
                if (fieldMemberModel.isMap()) {
                    this.getAssignmentValue(sb, (JsonNode)field.getValue(), fieldMemberModel);
                    continue;
                }
                sb.append(String.format(".with%s(", this.firstCharToUpper((String)field.getKey())));
                this.getAssignmentValue(sb, (JsonNode)field.getValue(), fieldMemberModel);
                sb.append(")");
            }
        }
    }

    private String formatPrimitiveValue(String type, String value) {
        if (type.equals("String")) {
            return String.format("\"%s\"", StringEscapeUtils.escapeJava((String)value));
        }
        if (type.equals("Boolean")) {
            return value.toLowerCase();
        }
        if (type.equals("Long")) {
            return value + "L";
        }
        if (type.equals("ByteBuffer")) {
            return String.format("ByteBuffer.wrap(\"%s\".getBytes())", StringEscapeUtils.escapeJava((String)value));
        }
        return value;
    }

    private void writeLine(String line) {
        this.sb.append(line + "\n");
    }

    private String firstCharToUpper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

