/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.PrivateIp;
import com.amazonaws.services.inspector.model.SecurityGroup;
import com.amazonaws.services.inspector.model.transform.NetworkInterfaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkInterface
implements Serializable,
Cloneable,
StructuredPojo {
    private String networkInterfaceId;
    private String subnetId;
    private String vpcId;
    private String privateDnsName;
    private String privateIpAddress;
    private List<PrivateIp> privateIpAddresses;
    private String publicDnsName;
    private String publicIp;
    private List<String> ipv6Addresses;
    private List<SecurityGroup> securityGroups;

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public NetworkInterface withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NetworkInterface withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public NetworkInterface withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public NetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public List<PrivateIp> getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<PrivateIp> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new ArrayList<PrivateIp>(privateIpAddresses);
    }

    public NetworkInterface withPrivateIpAddresses(PrivateIp ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses(new ArrayList<PrivateIp>(privateIpAddresses.length));
        }
        for (PrivateIp ele : privateIpAddresses) {
            this.privateIpAddresses.add(ele);
        }
        return this;
    }

    public NetworkInterface withPrivateIpAddresses(Collection<PrivateIp> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public NetworkInterface withPublicDnsName(String publicDnsName) {
        this.setPublicDnsName(publicDnsName);
        return this;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public NetworkInterface withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    public List<String> getIpv6Addresses() {
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<String> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new ArrayList<String>(ipv6Addresses);
    }

    public NetworkInterface withIpv6Addresses(String ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses(new ArrayList<String>(ipv6Addresses.length));
        }
        for (String ele : ipv6Addresses) {
            this.ipv6Addresses.add(ele);
        }
        return this;
    }

    public NetworkInterface withIpv6Addresses(Collection<String> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public List<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroup> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<SecurityGroup>(securityGroups);
    }

    public NetworkInterface withSecurityGroups(SecurityGroup ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroup>(securityGroups.length));
        }
        for (SecurityGroup ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public NetworkInterface withSecurityGroups(Collection<SecurityGroup> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.getPrivateIpAddresses()).append(",");
        }
        if (this.getPublicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.getPublicDnsName()).append(",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: ").append(this.getPublicIp()).append(",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.getIpv6Addresses()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getPublicDnsName() == null ^ this.getPublicDnsName() == null) {
            return false;
        }
        if (other.getPublicDnsName() != null && !other.getPublicDnsName().equals(this.getPublicDnsName())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDnsName() == null ? 0 : this.getPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    public NetworkInterface clone() {
        try {
            return (NetworkInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkInterfaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

