/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector.model.FailedItemDetails;
import com.amazonaws.services.inspector.model.ResourceGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeResourceGroupsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ResourceGroup> resourceGroups;
    private Map<String, FailedItemDetails> failedItems;

    public List<ResourceGroup> getResourceGroups() {
        return this.resourceGroups;
    }

    public void setResourceGroups(Collection<ResourceGroup> resourceGroups) {
        if (resourceGroups == null) {
            this.resourceGroups = null;
            return;
        }
        this.resourceGroups = new ArrayList<ResourceGroup>(resourceGroups);
    }

    public DescribeResourceGroupsResult withResourceGroups(ResourceGroup ... resourceGroups) {
        if (this.resourceGroups == null) {
            this.setResourceGroups(new ArrayList<ResourceGroup>(resourceGroups.length));
        }
        for (ResourceGroup ele : resourceGroups) {
            this.resourceGroups.add(ele);
        }
        return this;
    }

    public DescribeResourceGroupsResult withResourceGroups(Collection<ResourceGroup> resourceGroups) {
        this.setResourceGroups(resourceGroups);
        return this;
    }

    public Map<String, FailedItemDetails> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.failedItems = failedItems;
    }

    public DescribeResourceGroupsResult withFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public DescribeResourceGroupsResult addFailedItemsEntry(String key, FailedItemDetails value) {
        if (null == this.failedItems) {
            this.failedItems = new HashMap<String, FailedItemDetails>();
        }
        if (this.failedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.failedItems.put(key, value);
        return this;
    }

    public DescribeResourceGroupsResult clearFailedItemsEntries() {
        this.failedItems = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceGroups() != null) {
            sb.append("ResourceGroups: ").append(this.getResourceGroups()).append(",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: ").append(this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsResult)) {
            return false;
        }
        DescribeResourceGroupsResult other = (DescribeResourceGroupsResult)obj;
        if (other.getResourceGroups() == null ^ this.getResourceGroups() == null) {
            return false;
        }
        if (other.getResourceGroups() != null && !other.getResourceGroups().equals(this.getResourceGroups())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceGroups() == null ? 0 : this.getResourceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public DescribeResourceGroupsResult clone() {
        try {
            return (DescribeResourceGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

