/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector2.model.Ec2Metadata;
import java.util.Map;

@SdkInternalApi
public class Ec2MetadataMarshaller {
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amiId").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final Ec2MetadataMarshaller instance = new Ec2MetadataMarshaller();

    public static Ec2MetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ec2Metadata ec2Metadata, ProtocolMarshaller protocolMarshaller) {
        if (ec2Metadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ec2Metadata.getAmiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)ec2Metadata.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(ec2Metadata.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

