/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kendra.model.FacetResult;
import com.amazonaws.services.kendra.model.QueryResultItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String queryId;
    private List<QueryResultItem> resultItems;
    private List<FacetResult> facetResults;
    private Integer totalNumberOfResults;

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryResult withQueryId(String queryId) {
        this.setQueryId(queryId);
        return this;
    }

    public List<QueryResultItem> getResultItems() {
        return this.resultItems;
    }

    public void setResultItems(Collection<QueryResultItem> resultItems) {
        if (resultItems == null) {
            this.resultItems = null;
            return;
        }
        this.resultItems = new ArrayList<QueryResultItem>(resultItems);
    }

    public QueryResult withResultItems(QueryResultItem ... resultItems) {
        if (this.resultItems == null) {
            this.setResultItems(new ArrayList<QueryResultItem>(resultItems.length));
        }
        for (QueryResultItem ele : resultItems) {
            this.resultItems.add(ele);
        }
        return this;
    }

    public QueryResult withResultItems(Collection<QueryResultItem> resultItems) {
        this.setResultItems(resultItems);
        return this;
    }

    public List<FacetResult> getFacetResults() {
        return this.facetResults;
    }

    public void setFacetResults(Collection<FacetResult> facetResults) {
        if (facetResults == null) {
            this.facetResults = null;
            return;
        }
        this.facetResults = new ArrayList<FacetResult>(facetResults);
    }

    public QueryResult withFacetResults(FacetResult ... facetResults) {
        if (this.facetResults == null) {
            this.setFacetResults(new ArrayList<FacetResult>(facetResults.length));
        }
        for (FacetResult ele : facetResults) {
            this.facetResults.add(ele);
        }
        return this;
    }

    public QueryResult withFacetResults(Collection<FacetResult> facetResults) {
        this.setFacetResults(facetResults);
        return this;
    }

    public void setTotalNumberOfResults(Integer totalNumberOfResults) {
        this.totalNumberOfResults = totalNumberOfResults;
    }

    public Integer getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public QueryResult withTotalNumberOfResults(Integer totalNumberOfResults) {
        this.setTotalNumberOfResults(totalNumberOfResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryId() != null) {
            sb.append("QueryId: ").append(this.getQueryId()).append(",");
        }
        if (this.getResultItems() != null) {
            sb.append("ResultItems: ").append(this.getResultItems()).append(",");
        }
        if (this.getFacetResults() != null) {
            sb.append("FacetResults: ").append(this.getFacetResults()).append(",");
        }
        if (this.getTotalNumberOfResults() != null) {
            sb.append("TotalNumberOfResults: ").append(this.getTotalNumberOfResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResult)) {
            return false;
        }
        QueryResult other = (QueryResult)obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null) {
            return false;
        }
        if (other.getQueryId() != null && !other.getQueryId().equals(this.getQueryId())) {
            return false;
        }
        if (other.getResultItems() == null ^ this.getResultItems() == null) {
            return false;
        }
        if (other.getResultItems() != null && !other.getResultItems().equals(this.getResultItems())) {
            return false;
        }
        if (other.getFacetResults() == null ^ this.getFacetResults() == null) {
            return false;
        }
        if (other.getFacetResults() != null && !other.getFacetResults().equals(this.getFacetResults())) {
            return false;
        }
        if (other.getTotalNumberOfResults() == null ^ this.getTotalNumberOfResults() == null) {
            return false;
        }
        return other.getTotalNumberOfResults() == null || other.getTotalNumberOfResults().equals(this.getTotalNumberOfResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryId() == null ? 0 : this.getQueryId().hashCode());
        hashCode = 31 * hashCode + (this.getResultItems() == null ? 0 : this.getResultItems().hashCode());
        hashCode = 31 * hashCode + (this.getFacetResults() == null ? 0 : this.getFacetResults().hashCode());
        hashCode = 31 * hashCode + (this.getTotalNumberOfResults() == null ? 0 : this.getTotalNumberOfResults().hashCode());
        return hashCode;
    }

    public QueryResult clone() {
        try {
            return (QueryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

