/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.IssueSubEntity;
import com.amazonaws.services.kendra.model.transform.JiraConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JiraConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String jiraAccountUrl;
    private String secretArn;
    private Boolean useChangeLog;
    private List<String> project;
    private List<String> issueType;
    private List<String> status;
    private List<String> issueSubEntityFilter;
    private List<DataSourceToIndexFieldMapping> attachmentFieldMappings;
    private List<DataSourceToIndexFieldMapping> commentFieldMappings;
    private List<DataSourceToIndexFieldMapping> issueFieldMappings;
    private List<DataSourceToIndexFieldMapping> projectFieldMappings;
    private List<DataSourceToIndexFieldMapping> workLogFieldMappings;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private DataSourceVpcConfiguration vpcConfiguration;

    public void setJiraAccountUrl(String jiraAccountUrl) {
        this.jiraAccountUrl = jiraAccountUrl;
    }

    public String getJiraAccountUrl() {
        return this.jiraAccountUrl;
    }

    public JiraConfiguration withJiraAccountUrl(String jiraAccountUrl) {
        this.setJiraAccountUrl(jiraAccountUrl);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public JiraConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setUseChangeLog(Boolean useChangeLog) {
        this.useChangeLog = useChangeLog;
    }

    public Boolean getUseChangeLog() {
        return this.useChangeLog;
    }

    public JiraConfiguration withUseChangeLog(Boolean useChangeLog) {
        this.setUseChangeLog(useChangeLog);
        return this;
    }

    public Boolean isUseChangeLog() {
        return this.useChangeLog;
    }

    public List<String> getProject() {
        return this.project;
    }

    public void setProject(Collection<String> project) {
        if (project == null) {
            this.project = null;
            return;
        }
        this.project = new ArrayList<String>(project);
    }

    public JiraConfiguration withProject(String ... project) {
        if (this.project == null) {
            this.setProject(new ArrayList<String>(project.length));
        }
        for (String ele : project) {
            this.project.add(ele);
        }
        return this;
    }

    public JiraConfiguration withProject(Collection<String> project) {
        this.setProject(project);
        return this;
    }

    public List<String> getIssueType() {
        return this.issueType;
    }

    public void setIssueType(Collection<String> issueType) {
        if (issueType == null) {
            this.issueType = null;
            return;
        }
        this.issueType = new ArrayList<String>(issueType);
    }

    public JiraConfiguration withIssueType(String ... issueType) {
        if (this.issueType == null) {
            this.setIssueType(new ArrayList<String>(issueType.length));
        }
        for (String ele : issueType) {
            this.issueType.add(ele);
        }
        return this;
    }

    public JiraConfiguration withIssueType(Collection<String> issueType) {
        this.setIssueType(issueType);
        return this;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public void setStatus(Collection<String> status) {
        if (status == null) {
            this.status = null;
            return;
        }
        this.status = new ArrayList<String>(status);
    }

    public JiraConfiguration withStatus(String ... status) {
        if (this.status == null) {
            this.setStatus(new ArrayList<String>(status.length));
        }
        for (String ele : status) {
            this.status.add(ele);
        }
        return this;
    }

    public JiraConfiguration withStatus(Collection<String> status) {
        this.setStatus(status);
        return this;
    }

    public List<String> getIssueSubEntityFilter() {
        return this.issueSubEntityFilter;
    }

    public void setIssueSubEntityFilter(Collection<String> issueSubEntityFilter) {
        if (issueSubEntityFilter == null) {
            this.issueSubEntityFilter = null;
            return;
        }
        this.issueSubEntityFilter = new ArrayList<String>(issueSubEntityFilter);
    }

    public JiraConfiguration withIssueSubEntityFilter(String ... issueSubEntityFilter) {
        if (this.issueSubEntityFilter == null) {
            this.setIssueSubEntityFilter(new ArrayList<String>(issueSubEntityFilter.length));
        }
        for (String ele : issueSubEntityFilter) {
            this.issueSubEntityFilter.add(ele);
        }
        return this;
    }

    public JiraConfiguration withIssueSubEntityFilter(Collection<String> issueSubEntityFilter) {
        this.setIssueSubEntityFilter(issueSubEntityFilter);
        return this;
    }

    public JiraConfiguration withIssueSubEntityFilter(IssueSubEntity ... issueSubEntityFilter) {
        ArrayList<String> issueSubEntityFilterCopy = new ArrayList<String>(issueSubEntityFilter.length);
        for (IssueSubEntity value : issueSubEntityFilter) {
            issueSubEntityFilterCopy.add(value.toString());
        }
        if (this.getIssueSubEntityFilter() == null) {
            this.setIssueSubEntityFilter(issueSubEntityFilterCopy);
        } else {
            this.getIssueSubEntityFilter().addAll(issueSubEntityFilterCopy);
        }
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getAttachmentFieldMappings() {
        return this.attachmentFieldMappings;
    }

    public void setAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
        if (attachmentFieldMappings == null) {
            this.attachmentFieldMappings = null;
            return;
        }
        this.attachmentFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(attachmentFieldMappings);
    }

    public JiraConfiguration withAttachmentFieldMappings(DataSourceToIndexFieldMapping ... attachmentFieldMappings) {
        if (this.attachmentFieldMappings == null) {
            this.setAttachmentFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(attachmentFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : attachmentFieldMappings) {
            this.attachmentFieldMappings.add(ele);
        }
        return this;
    }

    public JiraConfiguration withAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
        this.setAttachmentFieldMappings(attachmentFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getCommentFieldMappings() {
        return this.commentFieldMappings;
    }

    public void setCommentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings) {
        if (commentFieldMappings == null) {
            this.commentFieldMappings = null;
            return;
        }
        this.commentFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(commentFieldMappings);
    }

    public JiraConfiguration withCommentFieldMappings(DataSourceToIndexFieldMapping ... commentFieldMappings) {
        if (this.commentFieldMappings == null) {
            this.setCommentFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(commentFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : commentFieldMappings) {
            this.commentFieldMappings.add(ele);
        }
        return this;
    }

    public JiraConfiguration withCommentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings) {
        this.setCommentFieldMappings(commentFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getIssueFieldMappings() {
        return this.issueFieldMappings;
    }

    public void setIssueFieldMappings(Collection<DataSourceToIndexFieldMapping> issueFieldMappings) {
        if (issueFieldMappings == null) {
            this.issueFieldMappings = null;
            return;
        }
        this.issueFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(issueFieldMappings);
    }

    public JiraConfiguration withIssueFieldMappings(DataSourceToIndexFieldMapping ... issueFieldMappings) {
        if (this.issueFieldMappings == null) {
            this.setIssueFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(issueFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : issueFieldMappings) {
            this.issueFieldMappings.add(ele);
        }
        return this;
    }

    public JiraConfiguration withIssueFieldMappings(Collection<DataSourceToIndexFieldMapping> issueFieldMappings) {
        this.setIssueFieldMappings(issueFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getProjectFieldMappings() {
        return this.projectFieldMappings;
    }

    public void setProjectFieldMappings(Collection<DataSourceToIndexFieldMapping> projectFieldMappings) {
        if (projectFieldMappings == null) {
            this.projectFieldMappings = null;
            return;
        }
        this.projectFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(projectFieldMappings);
    }

    public JiraConfiguration withProjectFieldMappings(DataSourceToIndexFieldMapping ... projectFieldMappings) {
        if (this.projectFieldMappings == null) {
            this.setProjectFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(projectFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : projectFieldMappings) {
            this.projectFieldMappings.add(ele);
        }
        return this;
    }

    public JiraConfiguration withProjectFieldMappings(Collection<DataSourceToIndexFieldMapping> projectFieldMappings) {
        this.setProjectFieldMappings(projectFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getWorkLogFieldMappings() {
        return this.workLogFieldMappings;
    }

    public void setWorkLogFieldMappings(Collection<DataSourceToIndexFieldMapping> workLogFieldMappings) {
        if (workLogFieldMappings == null) {
            this.workLogFieldMappings = null;
            return;
        }
        this.workLogFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(workLogFieldMappings);
    }

    public JiraConfiguration withWorkLogFieldMappings(DataSourceToIndexFieldMapping ... workLogFieldMappings) {
        if (this.workLogFieldMappings == null) {
            this.setWorkLogFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(workLogFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : workLogFieldMappings) {
            this.workLogFieldMappings.add(ele);
        }
        return this;
    }

    public JiraConfiguration withWorkLogFieldMappings(Collection<DataSourceToIndexFieldMapping> workLogFieldMappings) {
        this.setWorkLogFieldMappings(workLogFieldMappings);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public JiraConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public JiraConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public JiraConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public JiraConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public JiraConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJiraAccountUrl() != null) {
            sb.append("JiraAccountUrl: ").append(this.getJiraAccountUrl()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getUseChangeLog() != null) {
            sb.append("UseChangeLog: ").append(this.getUseChangeLog()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getIssueType() != null) {
            sb.append("IssueType: ").append(this.getIssueType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getIssueSubEntityFilter() != null) {
            sb.append("IssueSubEntityFilter: ").append(this.getIssueSubEntityFilter()).append(",");
        }
        if (this.getAttachmentFieldMappings() != null) {
            sb.append("AttachmentFieldMappings: ").append(this.getAttachmentFieldMappings()).append(",");
        }
        if (this.getCommentFieldMappings() != null) {
            sb.append("CommentFieldMappings: ").append(this.getCommentFieldMappings()).append(",");
        }
        if (this.getIssueFieldMappings() != null) {
            sb.append("IssueFieldMappings: ").append(this.getIssueFieldMappings()).append(",");
        }
        if (this.getProjectFieldMappings() != null) {
            sb.append("ProjectFieldMappings: ").append(this.getProjectFieldMappings()).append(",");
        }
        if (this.getWorkLogFieldMappings() != null) {
            sb.append("WorkLogFieldMappings: ").append(this.getWorkLogFieldMappings()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraConfiguration)) {
            return false;
        }
        JiraConfiguration other = (JiraConfiguration)obj;
        if (other.getJiraAccountUrl() == null ^ this.getJiraAccountUrl() == null) {
            return false;
        }
        if (other.getJiraAccountUrl() != null && !other.getJiraAccountUrl().equals(this.getJiraAccountUrl())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getUseChangeLog() == null ^ this.getUseChangeLog() == null) {
            return false;
        }
        if (other.getUseChangeLog() != null && !other.getUseChangeLog().equals(this.getUseChangeLog())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getIssueType() == null ^ this.getIssueType() == null) {
            return false;
        }
        if (other.getIssueType() != null && !other.getIssueType().equals(this.getIssueType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getIssueSubEntityFilter() == null ^ this.getIssueSubEntityFilter() == null) {
            return false;
        }
        if (other.getIssueSubEntityFilter() != null && !other.getIssueSubEntityFilter().equals(this.getIssueSubEntityFilter())) {
            return false;
        }
        if (other.getAttachmentFieldMappings() == null ^ this.getAttachmentFieldMappings() == null) {
            return false;
        }
        if (other.getAttachmentFieldMappings() != null && !other.getAttachmentFieldMappings().equals(this.getAttachmentFieldMappings())) {
            return false;
        }
        if (other.getCommentFieldMappings() == null ^ this.getCommentFieldMappings() == null) {
            return false;
        }
        if (other.getCommentFieldMappings() != null && !other.getCommentFieldMappings().equals(this.getCommentFieldMappings())) {
            return false;
        }
        if (other.getIssueFieldMappings() == null ^ this.getIssueFieldMappings() == null) {
            return false;
        }
        if (other.getIssueFieldMappings() != null && !other.getIssueFieldMappings().equals(this.getIssueFieldMappings())) {
            return false;
        }
        if (other.getProjectFieldMappings() == null ^ this.getProjectFieldMappings() == null) {
            return false;
        }
        if (other.getProjectFieldMappings() != null && !other.getProjectFieldMappings().equals(this.getProjectFieldMappings())) {
            return false;
        }
        if (other.getWorkLogFieldMappings() == null ^ this.getWorkLogFieldMappings() == null) {
            return false;
        }
        if (other.getWorkLogFieldMappings() != null && !other.getWorkLogFieldMappings().equals(this.getWorkLogFieldMappings())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        return other.getVpcConfiguration() == null || other.getVpcConfiguration().equals(this.getVpcConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJiraAccountUrl() == null ? 0 : this.getJiraAccountUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getUseChangeLog() == null ? 0 : this.getUseChangeLog().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getIssueType() == null ? 0 : this.getIssueType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getIssueSubEntityFilter() == null ? 0 : this.getIssueSubEntityFilter().hashCode());
        hashCode = 31 * hashCode + (this.getAttachmentFieldMappings() == null ? 0 : this.getAttachmentFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCommentFieldMappings() == null ? 0 : this.getCommentFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getIssueFieldMappings() == null ? 0 : this.getIssueFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getProjectFieldMappings() == null ? 0 : this.getProjectFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getWorkLogFieldMappings() == null ? 0 : this.getWorkLogFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        return hashCode;
    }

    public JiraConfiguration clone() {
        try {
            return (JiraConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JiraConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

