/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.SalesforceChatterFeedIncludeFilterType;
import com.amazonaws.services.kendra.model.transform.SalesforceChatterFeedConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SalesforceChatterFeedConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentDataFieldName;
    private String documentTitleFieldName;
    private List<DataSourceToIndexFieldMapping> fieldMappings;
    private List<String> includeFilterTypes;

    public void setDocumentDataFieldName(String documentDataFieldName) {
        this.documentDataFieldName = documentDataFieldName;
    }

    public String getDocumentDataFieldName() {
        return this.documentDataFieldName;
    }

    public SalesforceChatterFeedConfiguration withDocumentDataFieldName(String documentDataFieldName) {
        this.setDocumentDataFieldName(documentDataFieldName);
        return this;
    }

    public void setDocumentTitleFieldName(String documentTitleFieldName) {
        this.documentTitleFieldName = documentTitleFieldName;
    }

    public String getDocumentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public SalesforceChatterFeedConfiguration withDocumentTitleFieldName(String documentTitleFieldName) {
        this.setDocumentTitleFieldName(documentTitleFieldName);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public SalesforceChatterFeedConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public SalesforceChatterFeedConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public List<String> getIncludeFilterTypes() {
        return this.includeFilterTypes;
    }

    public void setIncludeFilterTypes(Collection<String> includeFilterTypes) {
        if (includeFilterTypes == null) {
            this.includeFilterTypes = null;
            return;
        }
        this.includeFilterTypes = new ArrayList<String>(includeFilterTypes);
    }

    public SalesforceChatterFeedConfiguration withIncludeFilterTypes(String ... includeFilterTypes) {
        if (this.includeFilterTypes == null) {
            this.setIncludeFilterTypes(new ArrayList<String>(includeFilterTypes.length));
        }
        for (String ele : includeFilterTypes) {
            this.includeFilterTypes.add(ele);
        }
        return this;
    }

    public SalesforceChatterFeedConfiguration withIncludeFilterTypes(Collection<String> includeFilterTypes) {
        this.setIncludeFilterTypes(includeFilterTypes);
        return this;
    }

    public SalesforceChatterFeedConfiguration withIncludeFilterTypes(SalesforceChatterFeedIncludeFilterType ... includeFilterTypes) {
        ArrayList<String> includeFilterTypesCopy = new ArrayList<String>(includeFilterTypes.length);
        for (SalesforceChatterFeedIncludeFilterType value : includeFilterTypes) {
            includeFilterTypesCopy.add(value.toString());
        }
        if (this.getIncludeFilterTypes() == null) {
            this.setIncludeFilterTypes(includeFilterTypesCopy);
        } else {
            this.getIncludeFilterTypes().addAll(includeFilterTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentDataFieldName() != null) {
            sb.append("DocumentDataFieldName: ").append(this.getDocumentDataFieldName()).append(",");
        }
        if (this.getDocumentTitleFieldName() != null) {
            sb.append("DocumentTitleFieldName: ").append(this.getDocumentTitleFieldName()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings()).append(",");
        }
        if (this.getIncludeFilterTypes() != null) {
            sb.append("IncludeFilterTypes: ").append(this.getIncludeFilterTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceChatterFeedConfiguration)) {
            return false;
        }
        SalesforceChatterFeedConfiguration other = (SalesforceChatterFeedConfiguration)obj;
        if (other.getDocumentDataFieldName() == null ^ this.getDocumentDataFieldName() == null) {
            return false;
        }
        if (other.getDocumentDataFieldName() != null && !other.getDocumentDataFieldName().equals(this.getDocumentDataFieldName())) {
            return false;
        }
        if (other.getDocumentTitleFieldName() == null ^ this.getDocumentTitleFieldName() == null) {
            return false;
        }
        if (other.getDocumentTitleFieldName() != null && !other.getDocumentTitleFieldName().equals(this.getDocumentTitleFieldName())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        if (other.getFieldMappings() != null && !other.getFieldMappings().equals(this.getFieldMappings())) {
            return false;
        }
        if (other.getIncludeFilterTypes() == null ^ this.getIncludeFilterTypes() == null) {
            return false;
        }
        return other.getIncludeFilterTypes() == null || other.getIncludeFilterTypes().equals(this.getIncludeFilterTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentDataFieldName() == null ? 0 : this.getDocumentDataFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentTitleFieldName() == null ? 0 : this.getDocumentTitleFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeFilterTypes() == null ? 0 : this.getIncludeFilterTypes().hashCode());
        return hashCode;
    }

    public SalesforceChatterFeedConfiguration clone() {
        try {
            return (SalesforceChatterFeedConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceChatterFeedConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

