/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.WebCrawlerMode;
import com.amazonaws.services.kendra.model.transform.SeedUrlConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SeedUrlConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> seedUrls;
    private String webCrawlerMode;

    public List<String> getSeedUrls() {
        return this.seedUrls;
    }

    public void setSeedUrls(Collection<String> seedUrls) {
        if (seedUrls == null) {
            this.seedUrls = null;
            return;
        }
        this.seedUrls = new ArrayList<String>(seedUrls);
    }

    public SeedUrlConfiguration withSeedUrls(String ... seedUrls) {
        if (this.seedUrls == null) {
            this.setSeedUrls(new ArrayList<String>(seedUrls.length));
        }
        for (String ele : seedUrls) {
            this.seedUrls.add(ele);
        }
        return this;
    }

    public SeedUrlConfiguration withSeedUrls(Collection<String> seedUrls) {
        this.setSeedUrls(seedUrls);
        return this;
    }

    public void setWebCrawlerMode(String webCrawlerMode) {
        this.webCrawlerMode = webCrawlerMode;
    }

    public String getWebCrawlerMode() {
        return this.webCrawlerMode;
    }

    public SeedUrlConfiguration withWebCrawlerMode(String webCrawlerMode) {
        this.setWebCrawlerMode(webCrawlerMode);
        return this;
    }

    public SeedUrlConfiguration withWebCrawlerMode(WebCrawlerMode webCrawlerMode) {
        this.webCrawlerMode = webCrawlerMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSeedUrls() != null) {
            sb.append("SeedUrls: ").append(this.getSeedUrls()).append(",");
        }
        if (this.getWebCrawlerMode() != null) {
            sb.append("WebCrawlerMode: ").append(this.getWebCrawlerMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeedUrlConfiguration)) {
            return false;
        }
        SeedUrlConfiguration other = (SeedUrlConfiguration)obj;
        if (other.getSeedUrls() == null ^ this.getSeedUrls() == null) {
            return false;
        }
        if (other.getSeedUrls() != null && !other.getSeedUrls().equals(this.getSeedUrls())) {
            return false;
        }
        if (other.getWebCrawlerMode() == null ^ this.getWebCrawlerMode() == null) {
            return false;
        }
        return other.getWebCrawlerMode() == null || other.getWebCrawlerMode().equals(this.getWebCrawlerMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSeedUrls() == null ? 0 : this.getSeedUrls().hashCode());
        hashCode = 31 * hashCode + (this.getWebCrawlerMode() == null ? 0 : this.getWebCrawlerMode().hashCode());
        return hashCode;
    }

    public SeedUrlConfiguration clone() {
        try {
            return (SeedUrlConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SeedUrlConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

