/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVersionsByFunctionResult
implements Serializable,
Cloneable {
    private String nextMarker;
    private ListWithAutoConstructFlag<FunctionConfiguration> versions;

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListVersionsByFunctionResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public List<FunctionConfiguration> getVersions() {
        if (this.versions == null) {
            this.versions = new ListWithAutoConstructFlag();
            this.versions.setAutoConstruct(true);
        }
        return this.versions;
    }

    public void setVersions(Collection<FunctionConfiguration> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        ListWithAutoConstructFlag versionsCopy = new ListWithAutoConstructFlag(versions.size());
        versionsCopy.addAll(versions);
        this.versions = versionsCopy;
    }

    public ListVersionsByFunctionResult withVersions(FunctionConfiguration ... versions) {
        if (this.getVersions() == null) {
            this.setVersions(new ArrayList<FunctionConfiguration>(versions.length));
        }
        for (FunctionConfiguration value : versions) {
            this.getVersions().add(value);
        }
        return this;
    }

    public ListVersionsByFunctionResult withVersions(Collection<FunctionConfiguration> versions) {
        if (versions == null) {
            this.versions = null;
        } else {
            ListWithAutoConstructFlag versionsCopy = new ListWithAutoConstructFlag(versions.size());
            versionsCopy.addAll(versions);
            this.versions = versionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: " + this.getVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVersionsByFunctionResult)) {
            return false;
        }
        ListVersionsByFunctionResult other = (ListVersionsByFunctionResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        return other.getVersions() == null || other.getVersions().equals(this.getVersions());
    }

    public ListVersionsByFunctionResult clone() {
        try {
            return (ListVersionsByFunctionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

