/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.DeleteAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteAliasRequestMarshaller
implements Marshaller<Request<DeleteAliasRequest>, DeleteAliasRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DeleteAliasRequest> marshall(DeleteAliasRequest deleteAliasRequest) {
        if (deleteAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases/{Name}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", deleteAliasRequest.getFunctionName() != null ? StringUtils.fromString((String)deleteAliasRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{Name}", deleteAliasRequest.getName() != null ? StringUtils.fromString((String)deleteAliasRequest.getName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

