/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteFunctionRequestMarshaller
implements Marshaller<Request<DeleteFunctionRequest>, DeleteFunctionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DeleteFunctionRequest> marshall(DeleteFunctionRequest deleteFunctionRequest) {
        if (deleteFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", deleteFunctionRequest.getFunctionName() != null ? StringUtils.fromString((String)deleteFunctionRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (deleteFunctionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)deleteFunctionRequest.getQualifier()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

