/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.GetAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetAliasRequestMarshaller
implements Marshaller<Request<GetAliasRequest>, GetAliasRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetAliasRequest> marshall(GetAliasRequest getAliasRequest) {
        if (getAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases/{Name}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getAliasRequest.getFunctionName() != null ? StringUtils.fromString((String)getAliasRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{Name}", getAliasRequest.getName() != null ? StringUtils.fromString((String)getAliasRequest.getName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

